/*
 * Rover.java
 *
 * Created on December 17, 2002
 */

package PER.rover;

import PER.rover.control.RoverController;
import java.io.*;


/**
 * High-level control of the Rover.
 *
 * @author  Rachel Gockley
 *
 */
public class Rover extends RoverController {
   
   /** Tells my code whether we are using the mars rover or the prototype */
   public final static boolean USING_MARS_ROVER = true;
       
    public static String topLevelDir = PER.PERConstants.filesystemPath+"SavedRoverFiles"; //directory for saved files, logs
    
    public static String defaultIP = "192.168.2.xx";
    private String IP = defaultIP; //the current ip address being used
    
    private Thread saveThread;
    
    
    /** Creates new Trikebot */
    public Rover() {
        super();
               
        //mySequencer = new Sequencer(this);
        
        // save the schedule and library every half hour
        saveThread = new Thread() {
            public void run() {
                try {
                    Thread.sleep(30*60*1000);
                } catch (Exception e) {
                }
            }
        };
        //saveThread.start(); //this caused the schedule to be saved before it was loaded, hence erasing the schedule
    }
    
    public void startSaveThread(){
        saveThread.start();
    }
    
    public static void setTopLevelDir(String s) {
        topLevelDir = s;
        //make sure top level directory exists
        File f = new File(topLevelDir);
        if(!f.exists()){
            f.mkdirs();
        }
    }
    
    public static String getTopLevelDir() {
        return topLevelDir;
    }

/*    public static String getExhibitPath() {
        return exhibitPath;
    }
*/    
    /** Returns the IP address currently being used. */
    public String getCurrentIP() {
        return IP;
    }
    /** Sets the current IP address being used. */
    public void setCurrentIP(String ip) {
        this.IP = ip;
    }
    
    public static String getDefaultIP() {
        // load the default IP address
        try {
            FileInputStream istream = new FileInputStream(new File(topLevelDir, "lastIP"));
            ObjectInputStream p = new ObjectInputStream(istream);
            
            String IPaddress = (String)p.readObject();
            
            istream.close();
            
            return IPaddress;
        } catch (Exception e) {
            Log.println("Loading the IP failed: " + e);
            return defaultIP;
        }
    }
    
    public static void saveIP(String IP) {
        try {
            FileOutputStream ostream = new FileOutputStream(new File(topLevelDir, "lastIP"));
            ObjectOutputStream p = new ObjectOutputStream(ostream);
            
            p.writeObject(IP);
            
            p.flush();
            ostream.close();
        } catch (Exception e) {
            Log.println("Saving the IP failed!");
        }
    }

}
