/*
 * Action.java
 *
 * Created on June 4, 2002, 3:26 PM
 */

package PER.rover;
import PER.rover.control.*;

/**
 * Interface for all Rover "actions" -- turning, moving, etc. All actions are
 * assumed to be "safe"; they should always avoid collisions independently (and
 * return false if they do)!
 * <p>
 * This used to be interface Motion, but was changed to allow for non-motion-related
 * Rover commands, such as looking for a landmark or sending a message.
 *
 * @author  Rachel Gockley
 * @version 2.0
 */
public interface Action extends java.io.Serializable {
    /** 
     * Tries to start the action. Returns whether the action started.
     */
    boolean doAction(Rover r);  // should be blocking

    /**
     * Emergency stop - end the action immediately, if it's running.
     */
    void kill();
    
    /** Whether the action completed successfully. Undefined until isCompleted() returns
     * true.
     */
    boolean isSuccess();

    /** Whether the action has completed. Undefined until doAction has been called.
     */
    boolean isCompleted();
    
    /** How long the action will take, in miliseconds. */
    int getTime();

    /** How much time until the action finishes (in miliseconds), if it has already
     * started. Undefined behavior if the action has not yet begun, or has finished.
     */
    int getTimeRemaining();
    
    /** The return value of the Action. 0 is a success. Negative implies one
     * of this class's constants. Other values should be interpreted as 
     * appropriate.
     */
    int getReturnValue();

    /** Provides a textual explanation of the Action, such as "turn 90 degrees" */
    String getSummary();
    
    /** Provides a shortened version of the summary returned by getSummary. For
     * example, getSummary may return something like "Turn left and drive about
     * 39 inches toward the red landmark," whereas getShortSummary might just
     * return "Drive toward a landmark."
     */
    String getShortSummary();
}
