package PER.exhibit.GUI;

import java.io.File;
import javax.swing.*;
import javax.swing.filechooser.*;


/* ImageFilter.java is a 1.4 example used by FileChooserDemo2.java. */
public class Filter extends FileFilter {
    public static final int IMAGE_FILTER = 0;
    public static final int TEXT_FILTER = 1;
    public static final int CALIBRATION_FILTER = 2;
    public static final int SCAN_FILTER = 3;
    
    private int type; //image or text filter
    
    public Filter(int type){
        super();
        this.type = type;
    }
    
    //Accept all directories and all gif, jpg, tiff, or png files.
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        
        String extension = getExtension(f);
        
        switch (type){
            case IMAGE_FILTER:
                if (extension != null) {
                    if (extension.equals("tiff") ||
                    extension.equals("tif") ||
                    extension.equals("gif") ||
                    extension.equals("jpeg") ||
                    extension.equals("jpg") ||
                    extension.equals("png"))
                        return true;
                    else
                        return false;
                }
                break;
            case TEXT_FILTER:
                if (extension != null) {
                    if (extension.equals("txt"))
                        return true;
                    else
                        return false;
                }
                break;
            case CALIBRATION_FILTER:
                if (extension != null) {
                    if (extension.equals("cal"))
                        return true;
                    else
                        return false;
                }
                break;
            case SCAN_FILTER:
                if (extension != null) {
                    if (extension.equals("scan"))
                        return true;
                    else
                        return false;
                }
                break;
        }
        return false;
    }
    
    //The description of this filter
    public String getDescription() {
        switch (type){
            case IMAGE_FILTER:
                return "Images";
            case TEXT_FILTER:
                return "Text Files";
            case CALIBRATION_FILTER:
                return "Calibration Files";
            case SCAN_FILTER:
                return "Scan Files";
            default:
                return  "";
        }
    }
    
    /*
     * Get the extension of a file.
     */
    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf('.');
        
        if (i > 0 &&  i < s.length() - 1) {
            ext = s.substring(i+1).toLowerCase();
        }
        return ext;
    }
}
