/*
 * Calibration.java
 *
 * Created on August 22, 2003, 10:28 AM
 */

package PER;
import PER.exhibit.GUI.Filter;

import PER.rover.control.*;
import java.awt.Color;
import java.util.*;
import javax.swing.JFileChooser;
import java.io.*;

/**
 *
 * @author  Eric
 */
public class Calibration extends javax.swing.JFrame {
   private RoverController rc = null;
   
   private static final int STEER_RANGE_BASE = 90;
   private static final int TILT_MIN_ALLOWED = -50;
   private static final int TILT_MAX_ALLOWED = 90;
   private static final int PAN_RANGE_BASE = 180;
   
   private static final int STEER_MIN_RANGE = 90;
   private static final int STEER_MAX_RANGE = 150;
   private static final int TILT_MIN_RANGE = (TILT_MAX_ALLOWED - TILT_MIN_ALLOWED)/2;
   private static final int TILT_MAX_RANGE = 150;
   private static final int PAN_MIN_RANGE = 180;
   private static final int PAN_MAX_RANGE = 360;
   
   //private static final int MOTOR0_MASK = 1;
   //private static final int MOTOR1_MASK = 2;
   private static final int FL_MASK = 4;
   private static final int FR_MASK = 8;
   private static final int BR_MASK = 16;
   private static final int BL_MASK = 32;
   private static final int PAN_MASK = 64;
   private static final int TILT_MASK = 128;
   private static final int ALL_MASK = 255;
   
   private Vector scans;
   //allows me to disable the sliders so that slider so that setting its value
   //won't send a command to the robot.
   private boolean useSlider = true;
   private int distance, angle;
   
   /** Creates new form Calibration */
   public Calibration() {
      initComponents();
      ipTF.setText(PER.rover.Rover.getDefaultIP());
      restoreDefaults();
      for(int i=0; i<servoPosPanel.getComponentCount(); i++)
         servoPosPanel.getComponent(i).setEnabled(false);
      for(int i=0; i<motorAdjustPanel.getComponentCount(); i++)
         motorAdjustPanel.getComponent(i).setEnabled(false);
      scans = new Vector();
   }
   
   private class ScanPosition {
      public int pan, tilt, thresh;
      public boolean takePicture;
      
      public ScanPosition(int pan, int tilt, int thresh, boolean takePic) {
         this.pan = pan;
         this.tilt = tilt;
         this.thresh = thresh;
         this.takePicture = takePic;
      }
      
      public String toString() {
         String str = "Pan: "+pan+" Tilt: "+tilt+" Threshold: "+thresh;
         if(takePicture)
            str = str + " pic";
         return str;
      }
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        ipTF = new javax.swing.JTextField();
        connectButton = new javax.swing.JButton();
        selectTabbedPane = new javax.swing.JTabbedPane();
        servoPanel = new javax.swing.JPanel();
        servoOpPanel = new javax.swing.JPanel();
        loadServoFromRoverButton = new javax.swing.JButton();
        saveServoToRoverButton = new javax.swing.JButton();
        saveServoToFileButton = new javax.swing.JButton();
        loadServoFromFileButton = new javax.swing.JButton();
        servoPosPanel = new javax.swing.JPanel();
        psLabel = new javax.swing.JLabel();
        psSlider = new javax.swing.JSlider();
        pscTF = new javax.swing.JTextField();
        RangeLabel = new javax.swing.JLabel();
        psrTF = new javax.swing.JTextField();
        tsLabel = new javax.swing.JLabel();
        tsSlider = new javax.swing.JSlider();
        flLabel = new javax.swing.JLabel();
        frLabel = new javax.swing.JLabel();
        blCenter = new javax.swing.JLabel();
        brLabel = new javax.swing.JLabel();
        flSlider = new javax.swing.JSlider();
        frSlider = new javax.swing.JSlider();
        blSlider = new javax.swing.JSlider();
        brSlider = new javax.swing.JSlider();
        tscTF = new javax.swing.JTextField();
        flcTF = new javax.swing.JTextField();
        frcTF = new javax.swing.JTextField();
        blcTF = new javax.swing.JTextField();
        brcTF = new javax.swing.JTextField();
        centerLabel = new javax.swing.JLabel();
        tsrTF = new javax.swing.JTextField();
        flrTF = new javax.swing.JTextField();
        frrTF = new javax.swing.JTextField();
        blrTF = new javax.swing.JTextField();
        brrTF = new javax.swing.JTextField();
        restoreDefaultsButton = new javax.swing.JButton();
        motorAdjustPanel = new javax.swing.JPanel();
        turnAdjustTF = new javax.swing.JTextField();
        turnAdjustLabel = new javax.swing.JLabel();
        driveButton = new javax.swing.JButton();
        turnButton = new javax.swing.JButton();
        driveAdjustTF = new javax.swing.JTextField();
        driveAdjustLabel = new javax.swing.JLabel();
        turnAngleTF = new javax.swing.JTextField();
        driveDistTF = new javax.swing.JTextField();
        scanPanel = new javax.swing.JPanel();
        scanOpPanel = new javax.swing.JPanel();
        loadScanFromRoverButton = new javax.swing.JButton();
        saveScanToRoverButton = new javax.swing.JButton();
        saveScanToFileButton = new javax.swing.JButton();
        loadScanFromFileButton = new javax.swing.JButton();
        scanEditPanel = new javax.swing.JPanel();
        ScanScrollPane = new javax.swing.JScrollPane();
        ScanList = new javax.swing.JList();
        statusLabel = new javax.swing.JLabel();
        ipLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Calibration Window");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        ipTF.setPreferredSize(new java.awt.Dimension(200, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        getContentPane().add(ipTF, gridBagConstraints);

        connectButton.setText("Connect");
        connectButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                connectButtonMouseClicked(evt);
            }
        });

        getContentPane().add(connectButton, new java.awt.GridBagConstraints());

        servoPanel.setLayout(new java.awt.GridBagLayout());

        servoOpPanel.setLayout(new java.awt.GridBagLayout());

        loadServoFromRoverButton.setText("Load Servo Calibration from Rover");
        loadServoFromRoverButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                loadServoFromRoverButtonMouseClicked(evt);
            }
        });

        servoOpPanel.add(loadServoFromRoverButton, new java.awt.GridBagConstraints());

        saveServoToRoverButton.setText("Save Servo Calibration to Rover");
        saveServoToRoverButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                saveServoToRoverButtonMouseClicked(evt);
            }
        });

        servoOpPanel.add(saveServoToRoverButton, new java.awt.GridBagConstraints());

        saveServoToFileButton.setText("Save Servo Calibration to File");
        saveServoToFileButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                saveServoToFileButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        servoOpPanel.add(saveServoToFileButton, gridBagConstraints);

        loadServoFromFileButton.setText("Load Servo Calibration from File");
        loadServoFromFileButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                loadServoFromFileButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        servoOpPanel.add(loadServoFromFileButton, gridBagConstraints);

        servoPanel.add(servoOpPanel, new java.awt.GridBagConstraints());

        servoPosPanel.setLayout(new java.awt.GridBagLayout());

        psLabel.setText("Pan");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        servoPosPanel.add(psLabel, gridBagConstraints);

        psSlider.setMaximum(255);
        psSlider.setMinimum(1);
        psSlider.setValue(128);
        psSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                psSliderStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = 10;
        servoPosPanel.add(psSlider, gridBagConstraints);

        pscTF.setText("128");
        pscTF.setPreferredSize(new java.awt.Dimension(40, 20));
        pscTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pscTFActionPerformed(evt);
            }
        });
        pscTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                pscTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        servoPosPanel.add(pscTF, gridBagConstraints);

        RangeLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        RangeLabel.setText("  Range ");
        RangeLabel.setPreferredSize(new java.awt.Dimension(50, 16));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        servoPosPanel.add(RangeLabel, gridBagConstraints);

        psrTF.setText("290");
        psrTF.setPreferredSize(new java.awt.Dimension(40, 20));
        psrTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                psrTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        servoPosPanel.add(psrTF, gridBagConstraints);

        tsLabel.setText("Tilt");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        servoPosPanel.add(tsLabel, gridBagConstraints);

        tsSlider.setMaximum(255);
        tsSlider.setMinimum(1);
        tsSlider.setValue(128);
        tsSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                tsSliderStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipady = 10;
        servoPosPanel.add(tsSlider, gridBagConstraints);

        flLabel.setText("Front Left");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        servoPosPanel.add(flLabel, gridBagConstraints);

        frLabel.setText("Front Right");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        servoPosPanel.add(frLabel, gridBagConstraints);

        blCenter.setText("Back Left");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        servoPosPanel.add(blCenter, gridBagConstraints);

        brLabel.setText("Back Right");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        servoPosPanel.add(brLabel, gridBagConstraints);

        flSlider.setMaximum(255);
        flSlider.setMinimum(1);
        flSlider.setValue(128);
        flSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                flSliderStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipady = 10;
        servoPosPanel.add(flSlider, gridBagConstraints);

        frSlider.setMaximum(255);
        frSlider.setMinimum(1);
        frSlider.setValue(128);
        frSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                frSliderStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipady = 10;
        servoPosPanel.add(frSlider, gridBagConstraints);

        blSlider.setMaximum(255);
        blSlider.setMinimum(1);
        blSlider.setValue(128);
        blSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                blSliderStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipady = 10;
        servoPosPanel.add(blSlider, gridBagConstraints);

        brSlider.setMaximum(255);
        brSlider.setMinimum(1);
        brSlider.setValue(128);
        brSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                brSliderStateChanged(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipady = 10;
        servoPosPanel.add(brSlider, gridBagConstraints);

        tscTF.setText("128");
        tscTF.setPreferredSize(new java.awt.Dimension(40, 20));
        tscTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tscTFActionPerformed(evt);
            }
        });
        tscTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tscTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        servoPosPanel.add(tscTF, gridBagConstraints);

        flcTF.setText("128");
        flcTF.setPreferredSize(new java.awt.Dimension(40, 20));
        flcTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                flcTFActionPerformed(evt);
            }
        });
        flcTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                flcTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        servoPosPanel.add(flcTF, gridBagConstraints);

        frcTF.setText("128");
        frcTF.setPreferredSize(new java.awt.Dimension(40, 20));
        frcTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                frcTFActionPerformed(evt);
            }
        });
        frcTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                frcTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        servoPosPanel.add(frcTF, gridBagConstraints);

        blcTF.setText("128");
        blcTF.setPreferredSize(new java.awt.Dimension(40, 20));
        blcTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                blcTFActionPerformed(evt);
            }
        });
        blcTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                blcTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        servoPosPanel.add(blcTF, gridBagConstraints);

        brcTF.setText("128");
        brcTF.setPreferredSize(new java.awt.Dimension(40, 20));
        brcTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                brcTFActionPerformed(evt);
            }
        });
        brcTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                brcTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        servoPosPanel.add(brcTF, gridBagConstraints);

        centerLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        centerLabel.setText("Center");
        centerLabel.setPreferredSize(new java.awt.Dimension(50, 16));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        servoPosPanel.add(centerLabel, gridBagConstraints);

        tsrTF.setText("82");
        tsrTF.setPreferredSize(new java.awt.Dimension(40, 20));
        tsrTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tsrTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        servoPosPanel.add(tsrTF, gridBagConstraints);

        flrTF.setText("-105");
        flrTF.setPreferredSize(new java.awt.Dimension(40, 20));
        flrTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                flrTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        servoPosPanel.add(flrTF, gridBagConstraints);

        frrTF.setText("-105");
        frrTF.setPreferredSize(new java.awt.Dimension(40, 20));
        frrTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                frrTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        servoPosPanel.add(frrTF, gridBagConstraints);

        blrTF.setText("-105");
        blrTF.setPreferredSize(new java.awt.Dimension(40, 20));
        blrTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                blrTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        servoPosPanel.add(blrTF, gridBagConstraints);

        brrTF.setText("-105");
        brrTF.setPreferredSize(new java.awt.Dimension(40, 20));
        brrTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                brrTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        servoPosPanel.add(brrTF, gridBagConstraints);

        restoreDefaultsButton.setText("Restore Defaults");
        restoreDefaultsButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                restoreDefaultsButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        servoPosPanel.add(restoreDefaultsButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        servoPanel.add(servoPosPanel, gridBagConstraints);

        motorAdjustPanel.setLayout(new java.awt.GridBagLayout());

        motorAdjustPanel.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)));
        turnAdjustTF.setText("100");
        turnAdjustTF.setPreferredSize(new java.awt.Dimension(45, 20));
        turnAdjustTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                turnAdjustTFActionPerformed(evt);
            }
        });
        turnAdjustTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                turnAdjustTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 0);
        motorAdjustPanel.add(turnAdjustTF, gridBagConstraints);

        turnAdjustLabel.setText("Turn Adjustment (80-125):  ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 0);
        motorAdjustPanel.add(turnAdjustLabel, gridBagConstraints);

        driveButton.setText("Drive");
        driveButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                driveButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 0);
        motorAdjustPanel.add(driveButton, gridBagConstraints);

        turnButton.setText("Turn");
        turnButton.setPreferredSize(new java.awt.Dimension(63, 26));
        turnButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                turnButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 0);
        motorAdjustPanel.add(turnButton, gridBagConstraints);

        driveAdjustTF.setText("100");
        driveAdjustTF.setPreferredSize(new java.awt.Dimension(45, 20));
        driveAdjustTF.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                driveAdjustTFActionPerformed(evt);
            }
        });
        driveAdjustTF.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                driveAdjustTFFocusLost(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 0);
        motorAdjustPanel.add(driveAdjustTF, gridBagConstraints);

        driveAdjustLabel.setText("Drive Adjustment (80-125):");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 0);
        motorAdjustPanel.add(driveAdjustLabel, gridBagConstraints);

        turnAngleTF.setText("90");
        turnAngleTF.setPreferredSize(new java.awt.Dimension(40, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 0);
        motorAdjustPanel.add(turnAngleTF, gridBagConstraints);

        driveDistTF.setText("50");
        driveDistTF.setPreferredSize(new java.awt.Dimension(40, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 0, 0);
        motorAdjustPanel.add(driveDistTF, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        servoPanel.add(motorAdjustPanel, gridBagConstraints);

        selectTabbedPane.addTab("Servo Calibration", servoPanel);

        scanPanel.setLayout(new java.awt.GridBagLayout());

        scanOpPanel.setLayout(new java.awt.GridBagLayout());

        loadScanFromRoverButton.setText("Load Scan Positions from Rover");
        loadScanFromRoverButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                loadScanFromRoverButtonMouseClicked(evt);
            }
        });

        scanOpPanel.add(loadScanFromRoverButton, new java.awt.GridBagConstraints());

        saveScanToRoverButton.setText("Save Scan Positions  to Rover");
        saveScanToRoverButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                saveScanToRoverButtonMouseClicked(evt);
            }
        });

        scanOpPanel.add(saveScanToRoverButton, new java.awt.GridBagConstraints());

        saveScanToFileButton.setText("Save Scan Positions to File");
        saveScanToFileButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                saveScanToFileButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        scanOpPanel.add(saveScanToFileButton, gridBagConstraints);

        loadScanFromFileButton.setText("Load Scan Positions from File");
        loadScanFromFileButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                loadScanFromFileButtonMouseClicked(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        scanOpPanel.add(loadScanFromFileButton, gridBagConstraints);

        scanPanel.add(scanOpPanel, new java.awt.GridBagConstraints());

        scanEditPanel.setLayout(new java.awt.GridBagLayout());

        ScanScrollPane.setPreferredSize(new java.awt.Dimension(250, 150));
        ScanScrollPane.setViewportView(ScanList);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        scanEditPanel.add(ScanScrollPane, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        scanPanel.add(scanEditPanel, gridBagConstraints);

        selectTabbedPane.addTab("Scan Calibration", scanPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        getContentPane().add(selectTabbedPane, gridBagConstraints);

        statusLabel.setText("Click 'Connect' to begin.");
        statusLabel.setPreferredSize(new java.awt.Dimension(440, 16));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        getContentPane().add(statusLabel, gridBagConstraints);

        ipLabel.setText("IP or hostname of Rover: ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
        getContentPane().add(ipLabel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
   
   private void driveAdjustTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_driveAdjustTFActionPerformed
      verifyDriveAdjustment();
   }//GEN-LAST:event_driveAdjustTFActionPerformed
   
   private void driveAdjustTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_driveAdjustTFFocusLost
      verifyDriveAdjustment();
   }//GEN-LAST:event_driveAdjustTFFocusLost
   
   private boolean verifyDriveAdjustment() {
      double adjustment;
      try{
         adjustment = Double.parseDouble(driveAdjustTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an number in the drive adjust field.");
         driveAdjustTF.setBackground(Color.PINK);
         return false;
      }
      if(adjustment < 80 || adjustment > 125) {
         statusLabel.setText("Drive adjustment must be between 80 and 125");
         driveAdjustTF.setBackground(Color.YELLOW);
         return false;
      }
      driveAdjustTF.setBackground(Color.WHITE);
      statusLabel.setText("");
      return true;
   }
   private void restoreDefaultsButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_restoreDefaultsButtonMouseClicked
      restoreDefaults();
   }//GEN-LAST:event_restoreDefaultsButtonMouseClicked
   
   private void driveButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_driveButtonMouseClicked
      if(rc == null) {
         statusLabel.setText("Connect first");
         return;
      }
      try {
         distance = Integer.parseInt(driveDistTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Type an integer in the drive dist field!");
         return;
      }
      Thread t = new Thread() {
         public void run() {
            rc.goTo(distance, 0);
            statusLabel.setText(PER.rover.ActionConstants.getErrorText(rc.state.getStatus()));
         }
      };
      t.start();
   }//GEN-LAST:event_driveButtonMouseClicked
   
   private void turnButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_turnButtonMouseClicked
      if(rc == null) {
         statusLabel.setText("Connect first");
         return;
      }
      try {
         angle = Integer.parseInt(turnAngleTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Type an integer in the turn angle field!");
         return;
      }
      Thread t = new Thread() {
         public void run() {
            rc.turnTo(angle);
            statusLabel.setText(PER.rover.ActionConstants.getErrorText(rc.state.getStatus()));
         }
      };
      t.start();
   }//GEN-LAST:event_turnButtonMouseClicked
   
   private void turnAdjustTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_turnAdjustTFActionPerformed
      verifyTurnAdjustment();
   }//GEN-LAST:event_turnAdjustTFActionPerformed
   
   private void turnAdjustTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_turnAdjustTFFocusLost
      verifyTurnAdjustment();
   }//GEN-LAST:event_turnAdjustTFFocusLost
   
   private boolean verifyTurnAdjustment() {
      double adjustment;
      try{
         adjustment = Double.parseDouble(turnAdjustTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an number in the turn adjust field.");
         turnAdjustTF.setBackground(Color.PINK);
         return false;
      }
      if(adjustment < 80 || adjustment > 125) {
         statusLabel.setText("Turn adjustment must be between 80 and 125");
         turnAdjustTF.setBackground(Color.YELLOW);
         return false;
      }
      turnAdjustTF.setBackground(Color.WHITE);
      statusLabel.setText("");
      return true;
   }
   
   private void saveScanToFileButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_saveScanToFileButtonMouseClicked
      JFileChooser chooser = new JFileChooser(PER.rover.Rover.topLevelDir+"/Calibration");
      Filter f = new Filter(Filter.SCAN_FILTER);
      chooser.setFileFilter(f);
      int returnVal = chooser.showOpenDialog(this);
      if(returnVal == JFileChooser.APPROVE_OPTION) {
         try {
            String file = ensureEndsWith(chooser.getSelectedFile().getAbsolutePath(), ".scan");
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(getScanString());
            out.close();
            statusLabel.setText("Successfully wrote file.");
         }catch(Exception e) {
            statusLabel.setText("Error writing file.");
         }
      }
   }//GEN-LAST:event_saveScanToFileButtonMouseClicked
   
   private void loadScanFromFileButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_loadScanFromFileButtonMouseClicked
      JFileChooser chooser = new JFileChooser(PER.rover.Rover.topLevelDir+"/Calibration");
      Filter f = new Filter(Filter.SCAN_FILTER);
      chooser.setFileFilter(f);
      int returnVal = chooser.showOpenDialog(this);
      int successfulLines = 0;
      if(returnVal == JFileChooser.APPROVE_OPTION) {
         try {
            BufferedReader in = new BufferedReader(new FileReader(chooser.getSelectedFile().getAbsolutePath()));
            String line = in.readLine();
            scans.clear();
            while(line != null) {
               if(parseScanLine(line))
                  successfulLines++;
               line = in.readLine();
               
            }
            in.close();
            ScanList.setListData(scans);
            statusLabel.setText("Loaded "+successfulLines+" scan lines from file.");
         }catch(Exception e) {
            statusLabel.setText("Error reading file.");
         }
      }
   }//GEN-LAST:event_loadScanFromFileButtonMouseClicked
   
   private void saveScanToRoverButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_saveScanToRoverButtonMouseClicked
      if(!verifyCenters() || !verifyRanges(false))
         return;
      if(rc == null)
         statusLabel.setText("Connect first");
      else {
         rc.setScanList(getScanString());
         statusLabel.setText(PER.rover.ActionConstants.getErrorText(rc.state.Status()));
      }
   }//GEN-LAST:event_saveScanToRoverButtonMouseClicked
   
   private void loadScanFromRoverButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_loadScanFromRoverButtonMouseClicked
      if(rc == null) {
         statusLabel.setText("Connect first");
         return;
      }
      String scanList = rc.getScanList();
      if(scanList == null) {
         if(rc.state.getStatus() == RoverState.SUCCESS)
            statusLabel.setText("No scan list file is currently on the robot.");
         else {
            statusLabel.setText(PER.rover.ActionConstants.getErrorText(rc.state.getStatus()));
            return;
         }
      }else {
         scans.clear();
         StringTokenizer strTok = new StringTokenizer(scanList, "\r\n");
         int successfulLines = 0;
         int lines = 0;
         while (strTok.hasMoreTokens()) {
            lines++;
            if(parseScanLine(strTok.nextToken()))
               successfulLines++;
         }
         System.out.println("there were "+lines+" lines loaded from rover");
         statusLabel.setText("Loaded "+successfulLines+" scan lines from rover.");
      }
      ScanList.setListData(scans);
   }//GEN-LAST:event_loadScanFromRoverButtonMouseClicked
   
   private void saveServoToFileButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_saveServoToFileButtonMouseClicked
      if(!verifyCenters() || !verifyRanges(false))
         return;
      JFileChooser chooser = new JFileChooser(PER.rover.Rover.topLevelDir+"/Calibration");
      Filter f = new Filter(Filter.CALIBRATION_FILTER);
      chooser.setFileFilter(f);
      int returnVal = chooser.showOpenDialog(this);
      if(returnVal == JFileChooser.APPROVE_OPTION) {
         try {
            String file = ensureEndsWith(chooser.getSelectedFile().getAbsolutePath(), ".cal");
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(getCalString());
            out.close();
            statusLabel.setText("Successfully wrote file.");
         }catch(Exception e) {
            statusLabel.setText("Error writing file.");
         }
      }
   }//GEN-LAST:event_saveServoToFileButtonMouseClicked
   
   private void loadServoFromFileButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_loadServoFromFileButtonMouseClicked
      JFileChooser chooser = new JFileChooser(PER.rover.Rover.topLevelDir+"/Calibration");
      Filter f = new Filter(Filter.CALIBRATION_FILTER);
      chooser.setFileFilter(f);
      int returnVal = chooser.showOpenDialog(this);
      int successfulLines = 0;
      if(returnVal == JFileChooser.APPROVE_OPTION) {
         try {
            BufferedReader in = new BufferedReader(new FileReader(chooser.getSelectedFile().getAbsolutePath()));
            String line = in.readLine();
            while(line != null) {
               if(parseLine(line))
                  successfulLines++;
               line = in.readLine();
            }
            in.close();
            verifyRanges(true);
            for(int i=0; i<servoPosPanel.getComponentCount(); i++)
               servoPosPanel.getComponent(i).setEnabled(true);
            for(int i=0; i<motorAdjustPanel.getComponentCount(); i++)
               motorAdjustPanel.getComponent(i).setEnabled(true);
            moveServosToCenter();
            statusLabel.setText("Loaded "+successfulLines+" lines of servo calibration from file.");
         }catch(Exception e) {
            statusLabel.setText("Error reading file.");
         }
      }
   }//GEN-LAST:event_loadServoFromFileButtonMouseClicked
   
   private void loadServoFromRoverButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_loadServoFromRoverButtonMouseClicked
      if(rc == null) {
         statusLabel.setText("Connect first");
         return;
      }
      String calibration = rc.getCalibration();
      if(calibration == null) {
         if(rc.state.getStatus() == RoverState.SUCCESS) {
            statusLabel.setText("No calibration file is currently on the robot.");
            restoreDefaults();
         }else {
            statusLabel.setText(PER.rover.ActionConstants.getErrorText(rc.state.getStatus()));
            return;
         }
      }else {
         //System.out.println(calibration);
         //config lines are separated by newlines
         StringTokenizer strTok = new StringTokenizer(calibration, "\r\n");
         int successfulLines = 0;
         while (strTok.hasMoreTokens()) {
            if(parseLine(strTok.nextToken()))
               successfulLines++;
         }
         statusLabel.setText("Loaded "+successfulLines+" lines of servo calibration from rover.");
         verifyRanges(true);
         moveServosToCenter();
      }
      for(int i=0; i<servoPosPanel.getComponentCount(); i++)
         servoPosPanel.getComponent(i).setEnabled(true);
      for(int i=0; i<motorAdjustPanel.getComponentCount(); i++)
         motorAdjustPanel.getComponent(i).setEnabled(true);
   }//GEN-LAST:event_loadServoFromRoverButtonMouseClicked
   
   /** Makes sure that the input String ends with the extension
    *  @param in the input string
    *  @param extension the extension you want String in to end with
    *  @return in, if in ends with extension, else in+extension
    */
   private String ensureEndsWith(String in, String extension) {
      if(in.endsWith(extension))
         return in;
      else
         return in+extension;
   }
   
   private void moveServosToCenter() {
      if(rc == null)
         return;
      int pan, tilt, fl, fr, bl, br;
      try {
         pan = Integer.parseInt(pscTF.getText());
      }catch(Exception e) {
         pan = 128;
      }
      try {
         tilt = Integer.parseInt(tscTF.getText());
      }catch(Exception e) {
         tilt = 108;
      }
      try {
         fl = Integer.parseInt(flcTF.getText());
      }catch(Exception e) {
         fl = 128;
      }
      try {
         fr = Integer.parseInt(frcTF.getText());
      }catch(Exception e) {
         fr = 128;
      }
      try {
         bl = Integer.parseInt(blcTF.getText());
      }catch(Exception e) {
         bl = 128;
      }
      try {
         br = Integer.parseInt(brcTF.getText());
      }catch(Exception e) {
         br = 128;
      }
      rc.setAll(ALL_MASK, 0, 0, fl, fr, br, bl, pan, tilt);
   }
   
   private void saveServoToRoverButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_saveServoToRoverButtonMouseClicked
      if(rc == null) {
         statusLabel.setText("Connect first");
         return;
      }else if(verifyRanges(false) && verifyCenters()){
         rc.setCalibration(getCalString());
         statusLabel.setText(PER.rover.ActionConstants.getErrorText(rc.state.Status()));
      }
   }//GEN-LAST:event_saveServoToRoverButtonMouseClicked
   
   private String getScanString() {
      StringBuffer cal = new StringBuffer(500);
      for(int i=0; i<scans.size(); i++) {
         ScanPosition sp = (ScanPosition) scans.get(i);
         cal.append("scan\tpan ").append(sp.pan).append("\ttilt ").append(sp.tilt).append("\tthresh ").append(sp.thresh);
         if(sp.takePicture)
            cal.append(" picture");
         cal.append("\n");
      }
      return cal.toString();
   }
   
   private String getCalString() {
      StringBuffer cal = new StringBuffer(300);
      cal.append("pan\tcenter ").append(pscTF.getText()).append("\trange ").append(psrTF.getText()).append("\n");
      cal.append("tilt\tcenter ").append(tscTF.getText()).append("\trange ").append(tsrTF.getText()).append("\n");
      cal.append("servo0\tcenter ").append(flcTF.getText()).append("\trange ").append(flrTF.getText()).append("\n");
      cal.append("servo1\tcenter ").append(frcTF.getText()).append("\trange ").append(frrTF.getText()).append("\n");
      cal.append("servo2\tcenter ").append(brcTF.getText()).append("\trange ").append(brrTF.getText()).append("\n");
      cal.append("servo3\tcenter ").append(blcTF.getText()).append("\trange ").append(blrTF.getText()).append("\n");
      cal.append("turn_adjust\t").append(turnAdjustTF.getText()).append("\n");
      cal.append("drive_adjust\t").append(driveAdjustTF.getText()).append("\n");
      return cal.toString();
   }
   
   private void brcTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_brcTFFocusLost
      verifyBRCenter(true);
   }//GEN-LAST:event_brcTFFocusLost
   
   private void brcTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_brcTFActionPerformed
      verifyBRCenter(true);
   }//GEN-LAST:event_brcTFActionPerformed
   
   private void brSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_brSliderStateChanged
      if(useSlider) {
         int value = brSlider.getValue();
         brcTF.setText(Integer.toString(value));
         if(rc != null)
            moveStatusChange(rc.setAll(BR_MASK, 0, 0, 0, 0, value, 0, 0, 0));
      }
   }//GEN-LAST:event_brSliderStateChanged
   
   private void blcTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_blcTFFocusLost
      verifyBLCenter(true);
   }//GEN-LAST:event_blcTFFocusLost
   
   private void blcTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_blcTFActionPerformed
      verifyBLCenter(true);
   }//GEN-LAST:event_blcTFActionPerformed
   
   private void blSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_blSliderStateChanged
      if(useSlider) {
         int value = blSlider.getValue();
         blcTF.setText(Integer.toString(value));
         if(rc != null)
            moveStatusChange(rc.setAll(BL_MASK, 0, 0, 0, 0, 0, value, 0, 0));
      }
   }//GEN-LAST:event_blSliderStateChanged
   
   private void frcTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_frcTFFocusLost
      verifyFRCenter(true);
   }//GEN-LAST:event_frcTFFocusLost
   
   private void frcTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_frcTFActionPerformed
      verifyFRCenter(true);
   }//GEN-LAST:event_frcTFActionPerformed
   
   private void frSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_frSliderStateChanged
      if(useSlider) {
         int value = frSlider.getValue();
         frcTF.setText(Integer.toString(value));
         if(rc != null)
            moveStatusChange(rc.setAll(FR_MASK, 0, 0, 0, value, 0, 0, 0, 0));
      }
   }//GEN-LAST:event_frSliderStateChanged
   
   private void flcTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_flcTFFocusLost
      verifyFLCenter(true);
   }//GEN-LAST:event_flcTFFocusLost
   
   private void flcTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_flcTFActionPerformed
      verifyFLCenter(true);
   }//GEN-LAST:event_flcTFActionPerformed
   
   private void flSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_flSliderStateChanged
      if(useSlider) {
         int value = flSlider.getValue();
         flcTF.setText(Integer.toString(value));
         if(rc != null)
            moveStatusChange(rc.setAll(FL_MASK, 0, 0, value, 0, 0, 0, 0, 0));
      }
   }//GEN-LAST:event_flSliderStateChanged
   
   private void tscTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tscTFFocusLost
      verifyTiltCenter(true);
   }//GEN-LAST:event_tscTFFocusLost
   
   private void tscTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tscTFActionPerformed
      verifyTiltCenter(true);
   }//GEN-LAST:event_tscTFActionPerformed
   
   private void tsSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_tsSliderStateChanged
      if(useSlider) {
         int value = tsSlider.getValue();
         tscTF.setText(Integer.toString(value));
         if(rc != null)
            moveStatusChange(rc.setAll(TILT_MASK, 0, 0, 0, 0, 0, 0, 0, value));
      }
   }//GEN-LAST:event_tsSliderStateChanged
   
   private void pscTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_pscTFFocusLost
      verifyPanCenter(true);
   }//GEN-LAST:event_pscTFFocusLost
   
   private void pscTFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pscTFActionPerformed
      verifyPanCenter(true);
   }//GEN-LAST:event_pscTFActionPerformed
   
   private void psSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_psSliderStateChanged
      if(useSlider) {
         int value = psSlider.getValue();
         pscTF.setText(Integer.toString(value));
         if(rc != null)
            moveStatusChange(rc.setAll(PAN_MASK, 0, 0, 0, 0, 0, 0, value, 0));
      }
   }//GEN-LAST:event_psSliderStateChanged
   
   private boolean verifyPanCenter(boolean send) {
      int min = psSlider.getMinimum();
      int max = psSlider.getMaximum();
      int value;
      try {
         value = Integer.parseInt(pscTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the pan center field.");
         pscTF.setBackground(Color.PINK);
         return false;
      }
      if(value < 1 || value > 255) {
         statusLabel.setText("Pan center must be between 1 and 255.");
         pscTF.setBackground(Color.PINK);
         return false;
      }
      if(send) {
         boolean success = rc.setAll(PAN_MASK, 0, 0, 0, 0, 0, 0, value, 0);
         if((value < min || value > max) && success)
            statusLabel.setText("If "+value+" is the center, repositioning servo recommended.");
         else
            moveStatusChange(success);
         
         value = Math.min(Math.max(value, min), max);
         useSlider = false;
         psSlider.setValue(value);
         useSlider = true;
      }
      pscTF.setBackground(Color.WHITE);
      return true;
   }
   
   private boolean verifyTiltCenter(boolean send) {
      int min = tsSlider.getMinimum();
      int max = tsSlider.getMaximum();
      int value;
      try {
         value = Integer.parseInt(tscTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the tilt center field.");
         tscTF.setBackground(Color.PINK);
         return false;
      }
      if(value < 1 || value > 255) {
         statusLabel.setText("Tilt center must be between 1 and 255.");
         tscTF.setBackground(Color.PINK);
         return false;
      }
      if(send) {
         boolean success = rc.setAll(TILT_MASK, 0, 0, 0, 0, 0, 0, 0, value);
         if((value < min || value > max) && success)
            statusLabel.setText("If "+value+" is the center, repositioning servo recommended.");
         else
            moveStatusChange(success);
         
         value = Math.min(Math.max(value, min), max);
         useSlider = false;
         tsSlider.setValue(value);
         useSlider = true;
      }
      tscTF.setBackground(Color.WHITE);
      return true;
   }
   
   private boolean verifyFLCenter(boolean send) {
      int min = flSlider.getMinimum();
      int max = flSlider.getMaximum();
      int value;
      try {
         value = Integer.parseInt(flcTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the front left center field.");
         flcTF.setBackground(Color.PINK);
         return false;
      }
      if(value < 1 || value > 255) {
         statusLabel.setText("Front left center must be between 1 and 255.");
         flcTF.setBackground(Color.PINK);
         return false;
      }
      if(send) {
         boolean success = rc.setAll(FL_MASK, 0, 0, value, 0, 0, 0, 0, 0);
         if((value < min || value > max) && success)
            statusLabel.setText("If "+value+" is the center, repositioning servo recommended.");
         else
            moveStatusChange(success);
         
         value = Math.min(Math.max(value, min), max);
         useSlider = false;
         flSlider.setValue(value);
         useSlider = true;
      }
      flcTF.setBackground(Color.WHITE);
      return true;
   }
   
   private boolean verifyFRCenter(boolean send) {
      int min = frSlider.getMinimum();
      int max = frSlider.getMaximum();
      int value;
      try {
         value = Integer.parseInt(frcTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the front right center field.");
         frcTF.setBackground(Color.PINK);
         return false;
      }
      if(value < 1 || value > 255) {
         statusLabel.setText("Front right center must be between 1 and 255.");
         frcTF.setBackground(Color.PINK);
         return false;
      }
      if(send) {
         boolean success = rc.setAll(FR_MASK, 0, 0, 0, value, 0, 0, 0, 0);
         if((value < min || value > max) && success)
            statusLabel.setText("If "+value+" is the center, repositioning servo recommended.");
         else
            moveStatusChange(success);
         
         value = Math.min(Math.max(value, min), max);
         useSlider = false;
         frSlider.setValue(value);
         useSlider = true;
      }
      frcTF.setBackground(Color.WHITE);
      return true;
   }
   
   private boolean verifyBRCenter(boolean send) {
      int min = brSlider.getMinimum();
      int max = brSlider.getMaximum();
      int value;
      try {
         value = Integer.parseInt(brcTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the back right center field.");
         brcTF.setBackground(Color.PINK);
         return false;
      }
      if(value < 1 || value > 255) {
         statusLabel.setText("Back right center must be between 1 and 255.");
         brcTF.setBackground(Color.PINK);
         return false;
      }
      if(send) {
         boolean success = rc.setAll(BR_MASK, 0, 0, 0, 0, value, 0, 0, 0);
         if((value < min || value > max) && success)
            statusLabel.setText("If "+value+" is the center, repositioning servo recommended.");
         else
            moveStatusChange(success);
         
         value = Math.min(Math.max(value, min), max);
         useSlider = false;
         brSlider.setValue(value);
         useSlider = true;
      }
      brcTF.setBackground(Color.WHITE);
      return true;
   }
   
   private boolean verifyBLCenter(boolean send) {
      int min = blSlider.getMinimum();
      int max = blSlider.getMaximum();
      int value;
      try {
         value = Integer.parseInt(blcTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the back left center field.");
         blcTF.setBackground(Color.PINK);
         return false;
      }
      if(value < 1 || value > 255) {
         statusLabel.setText("Back left center must be between 1 and 255.");
         blcTF.setBackground(Color.PINK);
         return false;
      }
      if(send) {
         boolean success = rc.setAll(BL_MASK, 0, 0, 0, 0, 0, value, 0, 0);
         if((value < min || value > max) && success)
            statusLabel.setText("If "+value+" is the center, repositioning servo recommended.");
         else
            moveStatusChange(success);
         
         value = Math.min(Math.max(value, min), max);
         useSlider = false;
         blSlider.setValue(value);
         useSlider = true;
      }
      blcTF.setBackground(Color.WHITE);
      return true;
   }
   
   private void moveStatusChange(boolean success) {
      if(success)
         statusLabel.setText("Success");
      else
         statusLabel.setText(PER.rover.ActionConstants.getErrorText(rc.state.getStatus()));
   }
   
   private void brrTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_brrTFFocusLost
      verifyBRRange(false);
   }//GEN-LAST:event_brrTFFocusLost
   
   private void blrTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_blrTFFocusLost
      verifyBLRange(false);
   }//GEN-LAST:event_blrTFFocusLost
   
   private void frrTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_frrTFFocusLost
      verifyFRRange(false);
   }//GEN-LAST:event_frrTFFocusLost
   
   private void flrTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_flrTFFocusLost
      verifyFLRange(false);
   }//GEN-LAST:event_flrTFFocusLost
   
   private void tsrTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tsrTFFocusLost
      verifyTiltRange(false);
   }//GEN-LAST:event_tsrTFFocusLost
   
   private void psrTFFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_psrTFFocusLost
      verifyPanRange(false);
   }//GEN-LAST:event_psrTFFocusLost
   
   boolean parseScanLine(String line) {
      if(line == null || line.charAt(0) == '#') //skip any line beginning with '#'
         return false;
      StringTokenizer strTok = new StringTokenizer(line);
      String type, token, attr = null;
      if(strTok.hasMoreTokens())
         type = strTok.nextToken();
      else
         return false;
      
      if(type.equals("scan")) {
         int pan=0, tilt=0, thresh=0;
         boolean panSet=false, tiltSet=false, threshSet=false, takePic=false;
         while(strTok.hasMoreTokens()) {
            if(attr == null) {
               attr = strTok.nextToken();
               
               //if it is not a valid identifier, ignore it
               if(attr.equals("picture")) {
                  takePic = true;
                  attr = null;
               }else if(!attr.equals("pan") && !attr.equals("tilt") && !attr.equals("thresh"))
                  attr = null;
            }else {
               try{
                  int value = Integer.parseInt(strTok.nextToken());
                  if(attr.equals("pan")) {
                     pan = value;
                     panSet = true;
                  }else if(attr.equals("tilt")) {
                     tilt = value;
                     tiltSet = true;
                  }else if(attr.equals("thresh")) {
                     thresh = value;
                     threshSet = true;
                  }
               }catch(Exception e) {}
               attr = null;
            }
         }
         //if the line contained all the info I need
         if(panSet && tiltSet && threshSet) {
            scans.add(new ScanPosition(pan, tilt, thresh, takePic));
            return true;
         }
      }
      return false;
   }
   
   boolean parseLine(String line) {
      if(line == null || line.charAt(0) == '#') //skip any line beginning with '#'
         return false;
      StringTokenizer strTok = new StringTokenizer(line);
      String type, token, attr = null;
      if(strTok.hasMoreTokens())
         type = strTok.nextToken();
      else
         return false;
      
      if(type.equals("turn_adjust")) {
         if(strTok.hasMoreTokens()) {
            turnAdjustTF.setText(strTok.nextToken());
            return true;
         }
      }
      
      if(type.equals("drive_adjust")) {
         if(strTok.hasMoreTokens()) {
            driveAdjustTF.setText(strTok.nextToken());
            return true;
         }
      }
      
      boolean filledTF = false;
      while(strTok.hasMoreTokens()) {
         if(attr == null) {
            attr = strTok.nextToken();
            //if it is not a valid identifier, ignore it
            if(!attr.equals("center") && !attr.equals("range"))
               attr = null;
         }else {
            String val = strTok.nextToken();
            filledTF = fillTF(type, attr, val) || filledTF;
            attr = null;
         }
      }
      return filledTF;
   }
   
   //return true if it filled a text field
   private boolean fillTF(String type, String attr, String val) {
      try {
         if(type.equals("servo0")) {
            if(attr.equals("center")) {
               flSlider.setValue(Integer.parseInt(val));
               flcTF.setText(val);
            }else if(attr.equals("range"))
               flrTF.setText(val);
            else
               return false;
         }else if(type.equals("servo1")) {
            if(attr.equals("center")){
               frSlider.setValue(Integer.parseInt(val));
               frcTF.setText(val);
            }else if(attr.equals("range"))
               frrTF.setText(val);
            else
               return false;
         }else if(type.equals("servo2")) {
            if(attr.equals("center")) {
               brSlider.setValue(Integer.parseInt(val));
               brcTF.setText(val);
            }else if(attr.equals("range"))
               brrTF.setText(val);
            else
               return false;
         }else if(type.equals("servo3")) {
            if(attr.equals("center")) {
               blSlider.setValue(Integer.parseInt(val));
               blcTF.setText(val);
            }else if(attr.equals("range"))
               blrTF.setText(val);
            else
               return false;
         }else if(type.equals("pan")) {
            if(attr.equals("center")) {
               psSlider.setValue(Integer.parseInt(val));
               pscTF.setText(val);
            }else if(attr.equals("range"))
               psrTF.setText(val);
            else
               return false;
         }else if(type.equals("tilt")) {
            if(attr.equals("center")) {
               tsSlider.setValue(Integer.parseInt(val));
               tscTF.setText(val);
            }else if(attr.equals("range"))
               tsrTF.setText(val);
            else
               return false;
         }else
            return false;
      }catch(NumberFormatException nfe) {
         return false;
      }
      return true;
   }
   
   private void connectButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_connectButtonMouseClicked
      if(rc != null)
         rc.closeComm();
      else
         rc = new RoverController();
      if(!rc.initComm(ipTF.getText())) {
         statusLabel.setText("Unable to Connect");
         rc.closeComm();
         return;
      }
      if(!rc.refresh()) {
         if(rc.state.getStatus() == RoverState.BATTERY_LOW)
            statusLabel.setText("Batteries are too low");
         else if(rc.state.getStatus() == RoverState.CEREB_TIMEOUT)
            statusLabel.setText("Cerebellum timeout");
         else
            statusLabel.setText(PER.rover.ActionConstants.getErrorText(rc.state.getStatus()));
         rc.closeComm();
         return;
      }
      statusLabel.setText("Connected to "+ipTF.getText());
      PER.rover.Rover.saveIP(ipTF.getText());
      for(int i=0; i<servoPosPanel.getComponentCount(); i++)
         servoPosPanel.getComponent(i).setEnabled(false);
      for(int i=0; i<motorAdjustPanel.getComponentCount(); i++)
         motorAdjustPanel.getComponent(i).setEnabled(false);
   }//GEN-LAST:event_connectButtonMouseClicked
   
   private void disableCenter(javax.swing.JTextField tf, javax.swing.JSlider slider) {
      tf.setEnabled(false);
      slider.setEnabled(false);
   }
   
   private void enableCenter(javax.swing.JTextField tf, javax.swing.JSlider slider, int min, int max) {
      tf.setEnabled(true);
      slider.setEnabled(true);
      int center;
      try {
         center = Integer.parseInt(tf.getText());
      }catch(Exception e) {
         center = (min+max)/2;
      }
      int TFCenter = center;
      slider.setMinimum(min);
      slider.setMaximum(max);
      center = Math.min(Math.max(center, min), max);
      useSlider = false;
      //make it so that moving the slider here won't trigger an event
      slider.setValue(center);
      useSlider = true;
      tf.setText(Integer.toString(TFCenter));
   }
   
   private boolean verifyRanges(boolean correct){
      boolean errorFree = verifyFLRange(correct);
      errorFree = errorFree && verifyFRRange(correct);
      errorFree = errorFree && verifyBLRange(correct);
      errorFree = errorFree && verifyBRRange(correct);
      errorFree = errorFree && verifyTiltRange(correct);
      errorFree = errorFree && verifyPanRange(correct);
      errorFree = errorFree && verifyTurnAdjustment();
      errorFree = errorFree && verifyDriveAdjustment();
      return errorFree;
   }
   
   private boolean verifyCenters(){
      boolean errorFree = verifyFLCenter(false);
      errorFree = errorFree && verifyFRCenter(false);
      errorFree = errorFree && verifyBLCenter(false);
      errorFree = errorFree && verifyBRCenter(false);
      errorFree = errorFree && verifyTiltCenter(false);
      errorFree = errorFree && verifyPanCenter(false);
      return errorFree;
   }
   
   private boolean verifyPanRange(boolean correct) {
      int range;
      try{
         range = Integer.parseInt(psrTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the pan range field.");
         psrTF.setBackground(Color.PINK);
         disableCenter(pscTF, psSlider);
         return false;
      }
      if(Math.abs(range) < PAN_MIN_RANGE || Math.abs(range) > PAN_MAX_RANGE) {
         if(correct)
            psrTF.setText("210");
         else {
            statusLabel.setText("Pan range must be between "+PAN_MIN_RANGE+" and "+PAN_MAX_RANGE);
            psrTF.setBackground(Color.YELLOW);
            disableCenter(pscTF, psSlider);
            return false;
         }
      }
      psrTF.setBackground(Color.WHITE);
      statusLabel.setText("");
      int minVal = PAN_RANGE_BASE*128/Math.abs(range);
      enableCenter(pscTF, psSlider, minVal, 255-minVal);
      return true;
   }
   
   private boolean verifyTiltRange(boolean correct) {
      int range;
      try{
         range = Integer.parseInt(tsrTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the tilt range field.");
         tsrTF.setBackground(Color.PINK);
         return false;
      }
      if(Math.abs(range) < TILT_MIN_RANGE || Math.abs(range) > TILT_MAX_RANGE) {
         if(correct)
            tsrTF.setText("100");
         else {
            statusLabel.setText("Tilt range must be between "+TILT_MIN_RANGE+" and "+TILT_MAX_RANGE);
            tsrTF.setBackground(Color.YELLOW);
            return false;
         }
      }
      tsrTF.setBackground(Color.WHITE);
      statusLabel.setText("");
      if(range > 0) {
         int minVal = Math.abs(TILT_MIN_ALLOWED*128/range);
         int maxVal = 255 - Math.abs(TILT_MAX_ALLOWED*128/range);
         //System.out.println("enabled tilt center");
         enableCenter(tscTF, tsSlider, minVal, maxVal);
      }else {
         int minVal = Math.abs(TILT_MAX_ALLOWED*128/range);
         int maxVal = 255 - Math.abs(TILT_MIN_ALLOWED*128/range);
         enableCenter(tscTF, tsSlider, minVal, maxVal);
      }
      return true;
   }
   
   private boolean verifyFLRange(boolean correct) {
      int range;
      try{
         range = Integer.parseInt(flrTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the front left range field.");
         flrTF.setBackground(Color.PINK);
         return false;
      }
      if(Math.abs(range) < STEER_MIN_RANGE || Math.abs(range) > STEER_MAX_RANGE) {
         if(correct)
            flrTF.setText("100");
         else {
            statusLabel.setText("Front left range must be between "+STEER_MIN_RANGE+" and "+STEER_MAX_RANGE);
            flrTF.setBackground(Color.YELLOW);
            return false;
         }
      }
      flrTF.setBackground(Color.WHITE);
      statusLabel.setText("");
      int minVal = STEER_RANGE_BASE*128/Math.abs(range);
      enableCenter(flcTF, flSlider, minVal, 255-minVal);
      return true;
   }
   
   private boolean verifyFRRange(boolean correct) {
      int range;
      try{
         range = Integer.parseInt(frrTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the front right range field.");
         frrTF.setBackground(Color.PINK);
         return false;
      }
      if(Math.abs(range) < STEER_MIN_RANGE || Math.abs(range) > STEER_MAX_RANGE) {
         if(correct)
            frrTF.setText("100");
         else {
            statusLabel.setText("Front right range must be between "+STEER_MIN_RANGE+" and "+STEER_MAX_RANGE);
            frrTF.setBackground(Color.YELLOW);
            return false;
         }
      }
      frrTF.setBackground(Color.WHITE);
      statusLabel.setText("");
      int minVal = STEER_RANGE_BASE*128/Math.abs(range);
      enableCenter(frcTF, frSlider, minVal, 255-minVal);
      return true;
   }
   
   private boolean verifyBLRange(boolean correct) {
      int range;
      try{
         range = Integer.parseInt(blrTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the back left range field.");
         blrTF.setBackground(Color.PINK);
         return false;
      }
      if(Math.abs(range) < STEER_MIN_RANGE || Math.abs(range) > STEER_MAX_RANGE) {
         if(correct)
            blrTF.setText("100");
         else {
            statusLabel.setText("Back left range must be between "+STEER_MIN_RANGE+" and "+STEER_MAX_RANGE);
            blrTF.setBackground(Color.YELLOW);
            return false;
         }
      }
      blrTF.setBackground(Color.WHITE);
      statusLabel.setText("");
      int minVal = STEER_RANGE_BASE*128/Math.abs(range);
      enableCenter(blcTF, blSlider, minVal, 255-minVal);
      return true;
   }
   
   private boolean verifyBRRange(boolean correct) {
      int range;
      try{
         range = Integer.parseInt(brrTF.getText());
      }catch(NumberFormatException nfe) {
         statusLabel.setText("Enter an integer in the back right range field.");
         brrTF.setBackground(Color.PINK);
         return false;
      }
      if(Math.abs(range) < STEER_MIN_RANGE || Math.abs(range) > STEER_MAX_RANGE) {
         if(correct)
            brrTF.setText("100");
         else {
            statusLabel.setText("Back right range must be between "+STEER_MIN_RANGE+" and "+STEER_MAX_RANGE);
            brrTF.setBackground(Color.YELLOW);
            return false;
         }
      }
      brrTF.setBackground(Color.WHITE);
      statusLabel.setText("");
      int minVal = STEER_RANGE_BASE*128/Math.abs(range);
      enableCenter(brcTF, brSlider, minVal, 255-minVal);
      return true;
   }
   
   /** Exit the Application */
   private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
      System.exit(0);
   }//GEN-LAST:event_exitForm
   
   /**
    * @param args the command line arguments
    */
   public static void main(String args[]) {
      new Calibration().show();
   }
   
   private void restoreDefaults() {
      tsrTF.setText("82");
      psrTF.setText("290");
      frrTF.setText("-105");
      flrTF.setText("-105");
      brrTF.setText("-105");
      blrTF.setText("-105");
      verifyRanges(true);
      psSlider.setValue(128);
      tsSlider.setValue(97);
      frSlider.setValue(128);
      flSlider.setValue(128);
      brSlider.setValue(128);
      blSlider.setValue(128);
      
      turnAdjustTF.setText("100");
      driveAdjustTF.setText("100");
   }
   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel RangeLabel;
    private javax.swing.JList ScanList;
    private javax.swing.JScrollPane ScanScrollPane;
    private javax.swing.JLabel blCenter;
    private javax.swing.JSlider blSlider;
    private javax.swing.JTextField blcTF;
    private javax.swing.JTextField blrTF;
    private javax.swing.JLabel brLabel;
    private javax.swing.JSlider brSlider;
    private javax.swing.JTextField brcTF;
    private javax.swing.JTextField brrTF;
    private javax.swing.JLabel centerLabel;
    private javax.swing.JButton connectButton;
    private javax.swing.JLabel driveAdjustLabel;
    private javax.swing.JTextField driveAdjustTF;
    private javax.swing.JButton driveButton;
    private javax.swing.JTextField driveDistTF;
    private javax.swing.JLabel flLabel;
    private javax.swing.JSlider flSlider;
    private javax.swing.JTextField flcTF;
    private javax.swing.JTextField flrTF;
    private javax.swing.JLabel frLabel;
    private javax.swing.JSlider frSlider;
    private javax.swing.JTextField frcTF;
    private javax.swing.JTextField frrTF;
    private javax.swing.JLabel ipLabel;
    private javax.swing.JTextField ipTF;
    private javax.swing.JButton loadScanFromFileButton;
    private javax.swing.JButton loadScanFromRoverButton;
    private javax.swing.JButton loadServoFromFileButton;
    private javax.swing.JButton loadServoFromRoverButton;
    private javax.swing.JPanel motorAdjustPanel;
    private javax.swing.JLabel psLabel;
    private javax.swing.JSlider psSlider;
    private javax.swing.JTextField pscTF;
    private javax.swing.JTextField psrTF;
    private javax.swing.JButton restoreDefaultsButton;
    private javax.swing.JButton saveScanToFileButton;
    private javax.swing.JButton saveScanToRoverButton;
    private javax.swing.JButton saveServoToFileButton;
    private javax.swing.JButton saveServoToRoverButton;
    private javax.swing.JPanel scanEditPanel;
    private javax.swing.JPanel scanOpPanel;
    private javax.swing.JPanel scanPanel;
    private javax.swing.JTabbedPane selectTabbedPane;
    private javax.swing.JPanel servoOpPanel;
    private javax.swing.JPanel servoPanel;
    private javax.swing.JPanel servoPosPanel;
    private javax.swing.JLabel statusLabel;
    private javax.swing.JLabel tsLabel;
    private javax.swing.JSlider tsSlider;
    private javax.swing.JTextField tscTF;
    private javax.swing.JTextField tsrTF;
    private javax.swing.JLabel turnAdjustLabel;
    private javax.swing.JTextField turnAdjustTF;
    private javax.swing.JTextField turnAngleTF;
    private javax.swing.JButton turnButton;
    // End of variables declaration//GEN-END:variables
   
}
