#lang racket

; change to results to process your own results instead of mine.
;(define results-directory "results")
(define results-directory "mct-results")


(define (second-last lst)
  (list-ref lst (- (length lst) 2)))

(define (third-last lst)
  (list-ref lst (- (length lst) 3)))

(define (round-to places num)
  (/ (round (* num (expt 10 places)))
     (expt 10 places)))

;(define (milli->secs milliseconds)
;  (round (/ milliseconds 1000)))

;; takes time ms in milliseconds
(define (milliseconds->string ms)
  (if (<= ms 2000) 
      (format "~a msec" (round ms))
      (seconds->string (/ ms 1000))))

(define (seconds->string s)
  (if (<= s 900)
      (format "~a sec" (round s))
      (minutes->string (/ s 60))))

(define (minutes->string m)
  (if (<= m 600)
      (format "~a min" (round m))
      (hours->string (/ m 60))))

(define (hours->string h)
  (if (<= h 72)
      (format "~a hours" (round h))
      (format "~a days" (round (/ h 24)))))

;; using the single step model, we guess the crossover point.
(define (args->aert s p_other p_i r_base r_study gamma)
  (* (/ (+ p_other (* s p_i)) p_i)
     r_study))


(define expr->args second)

(define (expr->total-time expr)
  (second (last (third expr))))

(define (expr->sert expr)
  (third (second (second-last (third expr)))))

(define (expr->tests expr)
  (rest (third-last (third expr))))

(define (test->run-time test)
  (second (last test)))

          

(define results2 '())
(define results3 '())

(define (format-tests-of epsilon s p_other p_i r_base r_study gamma)
  (let ([fresh-expr 
         (read (open-input-file (format "~a/fresh-~a-~a-~a-~a-~a-~a-~a.rkt" 
                                        results-directory
                                        epsilon s p_other p_i r_base r_study gamma)))])
    (if (= s 2) (set! results2 (cons fresh-expr results2)) (void))
    (if (= s 3) (set! results3 (cons fresh-expr results3)) (void))
    (printf "~a & ~a & ~a & ~a & ~a & ~a & ~a & ~a \\\\ % ~a\n"
            s
            p_i
            p_other
            (round-to 2 (- 1 (* s p_i) p_other))
            r_base
            ; r_study would go here, but it's always 1
            gamma
            ;(inexact->exact (round-to 3 (args->aert s p_other p_i r_base r_study gamma)))
            (round-to 3 (expr->sert fresh-expr))
            (milliseconds->string (expr->total-time fresh-expr))
            ;(round-to 3 (expr->sert around-expr))
            ;(milliseconds->string (expr->total-time around-expr))
            epsilon)))

;(define (format-around-test-of epsilon s p_other p_i r_base r_study gamma)
;  (let ([around-expr 
;         (read (open-input-file (format "~a/around-~a-~a-~a-~a-~a-~a-~a.rkt"
;                                        results-directory
;                                        epsilon s p_other p_i r_base r_study gamma)))])
;    (if (= s 2) (set! results2 (cons around-expr results2)) (void))
;    (if (= s 3) (set! results3 (cons around-expr results3)) (void))
;    (printf "~a & ~a & ~a & ~a & ~a & ~a & ~a & ~a & ~a & ~a & ~a\\\\ % ~a\n"
;            s
;            p_i
;            p_other
;            (round-to 2 (- 1 (* s p_i) p_other))
;            r_base
;            ; r_study would go here, but it's always 1
;            gamma
;            (inexact->exact (round-to 3 (args->aert s p_other p_i r_base r_study gamma)))
;            "n/a" ;(round-to 3 (expr->sert fresh-expr))
;            "n/a" ;(milliseconds->string (expr->total-time fresh-expr))
;            (round-to 3 (expr->sert around-expr))
;            (milliseconds->string (expr->total-time around-expr))
;            epsilon)))


(define (hline)
  (printf "\\hline\n"))

(printf "\\begin{tabular}{|llllrl|rr|}\n")
(hline)
(printf "$s$ & $p_{\\mathsf{i}}$ & $p_{\\mathsf{o}}$ & $p_{\\emptyset}$ & $\\basereward$ & $\\gamma$ & $\\sert$ & time \\\\ % epsilon \n")
(hline)
(hline)
(format-tests-of 0.001 2 0.95 0.01 1000 1 0.01)
(format-tests-of 0.001 2 0.95 0.01 1000 1 0.1)
(format-tests-of 0.001 2 0.95 0.01 1000 1 0.9)
(hline)
(format-tests-of 0.001 2 0.95 0.01 10000 1 0.01)
(format-tests-of 0.001 2 0.95 0.01 10000 1 0.1)
(format-tests-of 0.001 2 0.95 0.01 10000 1 0.9)
(hline)
(format-tests-of 0.001 2 0.95 0.01 100 1 0.01)
(format-tests-of 0.001 2 0.95 0.01 100 1 0.1)
(format-tests-of 0.001 2 0.95 0.01 100 1 0.9)
(hline)
(format-tests-of 0.001 2 0.95 0.01 10 1 0.01)
(format-tests-of 0.001 2 0.95 0.01 10 1 0.1)
(format-tests-of 0.001 2 0.95 0.01 10 1 0.9)
(hline)
(format-tests-of 0.001 2 0.95 0.01 1 1 0.01)
(format-tests-of 0.001 2 0.95 0.01 1 1 0.1)
(format-tests-of 0.001 2 0.95 0.01 1 1 0.9)
(hline)
(format-tests-of 0.001 2 0.9698 0.0001 1000 1 0.01)
(format-tests-of 0.001 2 0.9698 0.0001 1000 1 0.1)
(format-tests-of 0.001 2 0.9698 0.0001 1000 1 0.9)
(hline)
(format-tests-of 0.001 2 0.9698 0.0001 10 1 0.01) ;
(format-tests-of 0.001 2 0.9698 0.0001 10 1 0.1)
(format-tests-of 0.001 2 0.9698 0.0001 10 1 0.9)
(hline)
(format-tests-of 0.001 2 0.9698 0.0001 1 1 0.01) ;
(format-tests-of 0.001 2 0.9698 0.0001 1 1 0.1)
(format-tests-of 0.001 2 0.9698 0.0001 1 1 0.9)
(hline)
(format-tests-of 0.001 2 0.95 0.0001 1000 1 0.01) ;
(format-tests-of 0.001 2 0.95 0.0001 1000 1 0.1)
(format-tests-of 0.001 2 0.95 0.0001 1000 1 0.9)
(hline)
(format-tests-of 0.001 2 0.8 0.01 1000 1 0.01)
(format-tests-of 0.001 2 0.8 0.01 1000 1 0.1)
(format-tests-of 0.001 2 0.8 0.01 1000 1 0.9)
(hline)
(hline)
(format-tests-of 0.001 3 0.94 0.01 1000 1 0.01)
(format-tests-of 0.001 3 0.94 0.01 1000 1 0.1)
(format-tests-of 0.001 3 0.94 0.01 1000 1 0.9)
(hline)
(printf "\\end{tabular}\n")

(printf "Number of exprs of s=2: ~a\n" (length results2))
(printf "Number of exprs of s=3: ~a\n" (length results3))

(define (runtime f results)
  (milliseconds->string (apply f (map (lambda (expr)
                                        (apply f (map (lambda (test) (test->run-time test))
                                                      (expr->tests expr))))
                                      results))))

(printf "min audit time for 2: ~a\n"
        (runtime min results2))
(printf "max audit time for 2: ~a\n"
        (runtime max results2))
(printf "min audit time for 3: ~a\n"
        (runtime min results3))
(printf "max audit time for 3: ~a\n"
        (runtime max results3))

(define (auditcalls f results)
  (apply f (map (lambda (expr)
                  (length (expr->tests expr)))
                results)))


(printf "min num of audit calls needed for each fresh 2: ~a\n"
        (auditcalls min
                    (filter (lambda (expr) (symbol=? (first expr) 'run-fresh-test))
                            results2)))

(printf "max num of audit calls needed for each fresh 2: ~a\n"
        (auditcalls max
                    (filter (lambda (expr) (symbol=? (first expr) 'run-fresh-test))
                            results2)))

;(printf "min num of audit calls needed for each around 2: ~a\n"
;        (auditcalls min
;                    (filter (lambda (expr) (symbol=? (first expr) 'run-around-test))
;                            results2)))
;
;(printf "max num of audit calls needed for each around 2: ~a\n"
;        (auditcalls max
;                    (filter (lambda (expr) (symbol=? (first expr) 'run-around-test))
;                            results2)))

(printf "min num of audit calls needed for each fresh 3: ~a\n"
        (auditcalls min
                    (filter (lambda (expr) (symbol=? (first expr) 'run-fresh-test))
                            results3)))
(printf "max num of audit calls needed for each fresh 3: ~a\n"
        (auditcalls max
                    (filter (lambda (expr) (symbol=? (first expr) 'run-fresh-test))
                            results3)))

;(printf "min num of audit calls needed for each around 3: ~a\n"
;        (auditcalls min
;                    (filter (lambda (expr) (symbol=? (first expr) 'run-around-test))
;                            results3)))
;
;(printf "max num of audit calls needed for each around 3: ~a\n"
;        (auditcalls max
;                    (filter (lambda (expr) (symbol=? (first expr) 'run-around-test))
;                            results3)))
