/*
 * A simple example of using the Scanner class
 * 
 * Margaret Reid-Miller
 */

import java.util.Scanner;   // NOTE: need to tell Java in which 
                            // package to find the Scanner class

public class MilesPerGallonCalculator {

	// Asks the user for the user's car make, miles driven,
	// and gallons used.  Displays the miles per gallon
	public static void main(String[] args) {
        // Create a Scanner object that can read user input from the console.
		// The variable console is the identifier (name) of the Scanner object
		Scanner console = new Scanner(System.in);
		
		// Prompt the user for the make of the car.
		System.out.print("What is the make of your vehicle? ");
		// When the user presses the return key, read the line
		// of text the user typed in the console as a string.
		String vehicleMake = console.nextLine();

		// Prompt the user for the number of miles and read it.
		System.out.print("How many miles did you drive? ");
		// When the user presses the return key, read the next
		// token (word) as an integer.
		// What happens if the user does not type an integer?
		int miles = console.nextInt();

		// Prompt the user for the number of gallons of fuel.
		System.out.print("How many gallons of fuel did you use? ");
		// Read the data as a double.
		double gallons = console.nextDouble();
		
		// Change the vehicleMake string to upper case (must 
		// reassign the string returned back to vehicleMake!)
		vehicleMake = vehicleMake.toUpperCase();
		
		// What happens if you now try to read the user's name?
		System.out.print("What is your name? ");
		String name = console.nextLine();
		
		// Compute the miles per gallon and print the result
		double mpg = miles / gallons;
		// round to 2 decimal places
		// mpg = ______________________________
		System.out.println(name + ",your " + vehicleMake + " got " +
				mpg + " miles per gallon.");
		


	}

}
