/*
 * Demonstrates some of the Math class methods, which perform
 * basic mathematical functions.
 */
public class ExampleMath {
	
	public static void main(String args[]) {
		
		// As all methods and constants in the Math class are static, 
		// their names are preceded by the class name, Math. No object
		// of the Math class needs to be instantiated before using the methods. 

		final double TWO_PI = 2.0 * Math.PI; // ??
		double radius = 5.0;
		double circumference = TWO_PI * radius;

		System.out.println("The circumference of a circle with radius "
			+ radius + " inches is equal to "
			+ circumference + " inches.");
		System.out.println();
			
		double sideA = 3.0;
		double sideB = 4.0;
		
		// The argument to the sqrt method can be an expression 

		double hypotenuse = Math.sqrt(Math.pow(sideA, 2.0) + Math.pow(sideB, 2.0));
//		double hypotenuse = Math.sqrt(_________________________);
		
		System.out.println("A triangle with sides of " + sideA
			+ " feet and " + sideB + " feet has a hypotenuse of " 
			+ hypotenuse + " feet.");
		System.out.println();
	/*	
		// NOTE: ceil and floor return a double (not an int)!
		double nextBigger = Math.ceil(4.3); // smallest whole number not less than num
		double nextSmaller = Math.floor(6.8); // largest whole number not greater than num
		int nextCloserToZero = (int) 6.8;  // fractional part is discarded.
		
		System.out.println("The ceiling of 4.3 is " + nextBigger);
		System.out.println("The floor   of 6.8 is " + nextSmaller);
		System.out.println("Truncated      2.5 is " + nextCloserToZero);
		System.out.println();
			
		nextBigger = Math.ceil(-4.3); // smallest whole number not less than num
		nextSmaller = Math.floor(-6.8); // largest whole number not greater than num
		nextCloserToZero = (int) -6.8;  // fractional part is discarded.
		
		System.out.println("The ceiling of -4.3 is " + nextBigger);
		System.out.println("The floor   of -6.8 is " + nextSmaller);
		System.out.println("Truncated      -2.5 is " + nextCloserToZero);
		System.out.println();
	*/
	}

	

}