/*
 * Generates Truth Tables, one for && and one for ||
 * 
 * Demonstrates methods with return value and Short Circuit Evaluation
 */
public class TruthTableGenerator3 {

	public static void main(String[] args) {
		System.out.println("Demo of return value:");
		boolean b;
		b = printValue(false);
		System.out.println("Returned value is " + b);
		b = printValue(true);
		System.out.println("Returned value is " + b);
		System.out.println();
		
//		printAndTable();		
		System.out.println();
		
//		printOrTable();
	}
	
	public static boolean printValue(boolean b) {
		if (b) {
			System.out.print("TRUE  ");
		}
		else {
			System.out.print("FALSE ");
		}
		return b;
	}
	
	public static void printAndTable() {
		System.out.println("&& Short Circuit Evaluation:");
		printAndHeader();
		printAndRow(true, true);
		printAndRow(true, false);
		printAndRow(false, true);
		printAndRow(false, false);
	}

	public static void printAndHeader() {
		System.out.println("  a\t  b\ta && b\t evaluation");
		System.out.println("-----\t------\t------\t-----------------");
		
	}
	
	public static void printAndRow(boolean a, boolean b) {
		System.out.print(a + "\t");
		System.out.print(b + "\t");
		System.out.print((a && b) + "\t");
		System.out.println(printValue(a) && printValue(b));
	}

	private static void printOrTable() {
		System.out.println("|| Short Circuit Evaluation:");
		printOrHeader();
		printOrRow(true, true);
		printOrRow(true, false);
		printOrRow(false, true);
		printOrRow(false, false);
	}
	
	public static void printOrHeader() {
		System.out.println("  a\t  b\ta || b\t evaluation");
		System.out.println("-----\t------\t------\t-----------------");
		
	}
	
	public static void printOrRow(boolean a, boolean b) {
		System.out.print(a + "\t");
		System.out.print(b + "\t");
		System.out.print((a || b) + "\t");
		System.out.println(printValue(a) || printValue(b));
	}
	
}
