// Sorts array by inserting one element at a time into a sorted array.
public class SortingInt {
    
    public static void main(String[] args) {

        System.out.println("Sorting using insertion sort:\n");
        int[] array1 = {3,2,5,1,7,4,6,9,3};
        printArray(array1);
        System.out.println(" // unsorted array");
        insertionSort(array1);
        
        System.out.println("Sorting using selection sort:\n");
        int[] array2 = {3,2,5,1,7,4,6,9,3};
        printArray(array2);
        System.out.println(" // unsorted array");
        selectionSort(array2);
        
    }
    
    // Sort array by inserting the next element into sorted part of the array
    // Precondition: array has num elements with no gaps
    // Postcondition: array is sorted in increasing order
    public static void insertionSort(int[] array) {
    
        for (int numSorted = 1; numSorted < array.length; numSorted++) {
            
	    // Invariant: The first numSorted elements are sorted 
	    // in increasing order.
	
	    // Insert element at numSorted at the appropriate position
	    // in the sorted part of the array.

	    // next element to insert in sorted list
            int temporary = array[numSorted];
    
	    // Now we have a "hole" at array[numSorted]. Move the hole
	    // to where we need to insert temporary, by shifting the
	    // elements one position towards the end of the array.
	    // Want to move hole to be where the elements before
	    // it are less than temporary and elements after hole
	    // are greater than or equal to temporary. 


    	    // Since we don't know where the hole will end up, we use
       	    // a while loop.

            int hole = numSorted;
            while (hole > 0 && temporary < array[hole-1]) {
                array[hole] = array[hole-1];
                hole--;
            }
    
            // Now we can put temporary back into the array at hole
            array[hole] = temporary; 
            printArray(array);
            System.out.println(" // inserted " + temporary);
        }
    }
    
    // Sort array by selecting the next element to add to a sorted array
    // Precondition: array has num elements with no gaps
    // Postcondition: array is sorted in increasing order
    public static void selectionSort(int[] array) {
    
    
        // Invariant: The first numSorted elements are in their final
        // sorted position
        for (int numSorted = 0; numSorted < array.length-1; numSorted++) {
            // (Why is it OK to skip the last element?)

            // Select the next element to add to first numSorted elements.
            // The next element is the smallest element in the unsorted
            // part of the array.
    
            // Since we need to look at all the elements we can use
            // a for loop.
            int minIndex = numSorted;
    
            for (int index = numSorted + 1; index < array.length; index++) {
                
                if (array[minIndex] > array[index]) {
                    minIndex = index; // found new min
                }    
            }
    
            // Swap value at minIndex with numSorted
            int temporary = array[minIndex];
            array[minIndex] = array[numSorted];
            array[numSorted] = temporary;
            printArray(array);
            System.out.println(" // selected " + array[numSorted]);
        }
    }
        
    public static void printArray(int[] array) {
        
        System.out.print("[ " + array[0]);
        for (int i = 1; i < array.length; i++) {
            System.out.print(", " + array[i]);
        }
        System.out.print(" ]");

     }
}
