
public class SodaCan {
	
	// What are the behaviors (methods) of a sodaCan
	// What attributes (fields) do you need to support these methods
	// Under what conditions can you safely execute the methods
	
	private int size;  // in mL
	private int amountRemaining;  // in mL
	private boolean opened;
	
	// Constructor: initializes all the fields
	public SodaCan(int numberOfMilliliters) {
		size = numberOfMilliliters;
		amountRemaining = size;
		opened = false;
	}

	// open it 
	public void open() {
		if (opened) {
			System.out.println("Already opened");
		}
		else {
			opened = true;		
		}
	}
	
	// drink the specified amount
	public void drink(int amount) {
		if (amount >= 0) {
			if (opened) {
				if (amountRemaining >= amount) {
					amountRemaining -= amount;
				}
				else if (amountRemaining > 0) {
					amountRemaining = 0;
				}
				else {
					System.out.println("Nothing left to drink");
				}
			}
			else {
				System.out.println("Cannot drink from an unopened can");
			}
		}
		else {
			System.out.println("Cannot drink a negative amount");
		}
	}
	
	// is it empty?
	public boolean isEmpty() {
		return (amountRemaining == 0); 
	}

	
	// print status  (print the state)
	public void printStatus() {
		System.out.println("Size: " + size);
		System.out.println("Amount Remaining: " + amountRemaining);
		if (opened) System.out.println("opened");
		else System.out.println("unopened");
		System.out.println();
	}


}
