// This class implements a song played on radio
//
// Written by: Tom Cortina
// Modified by: Margaret Reid-Miller and <your name here>
public class Song 
{
	private String title;
	private String artist;
	private int chartPosition;
	private int weeksOnChart;
	
	// create a brand new song
	public Song(String songTitle, String songArtist, 
				int currentChartPosition, int numWeeksOnChart)	{
		title = songTitle;
		artist = songArtist;
		chartPosition = currentChartPosition;
		weeksOnChart = numWeeksOnChart;
	}
	
	// returns the title of this song
	public String getTitle()	{
		return title;
	}
	
	// returns the artist of this song
	public String getArtist()	{
		return artist;
	}
	
	// returns the current chart position of this song 
	public int getChartPosition()	{
		return chartPosition;
	}
	
	// returns the number of weeks this song has been on the charts
	public int getWeeksOnChart() {
		return weeksOnChart;
	}
	
	public String toString()	{
		return "Title: " + getTitle() + ", Artist: " + getArtist()
				+ ", Chart Position: " + getChartPosition()
				+ ", Weeks On Chart: " + getWeeksOnChart();
	}
	
	public boolean equals(Song otherSong) {
		return this.title.equals(otherSong.title)
		       && this.artist.equals(otherSong.artist)
		       && this.chartPosition == otherSong.chartPosition
		       && this.weeksOnChart == otherSong.weeksOnChart;
	}

}
	
