/* "Piggy Six"
 * Two player dice game to illustrate loops, conditionals and methods parameters
 *
 * Rules:
 * Players alternate turns rolling two dice.
 *    - Player score is the product (traditionally the sum) of the two dice.
 *    - Player can keep rolling until the player chooses to stop.  The player 
 *      adds the sum of all the rolls scores to the player's total score.
 *    - If the player rolls a six, the player's turn ends immediately 
 *      and gets no points for that turn.
 *    - If the player rolls a pair of sixes, the player's turn ends immediately 
 *      and loses all the player's points (total goes to zero)!
 * The game ends if any player reaches 100 points
 *
 * Author: Tom Cortina, Spring 2006 - revised Fall 2006 for Java 5
 * Modified by: Margaret Reid-Miller, Fall 2007 by introducing a boolean
 * Modified by: Margaret Reid-Miller, Fall 2008 by factoring out methods
 *                                    introducing a named class constant
 */

import java.util.*;

public class PiggySix {

	static final int SCORE_TO_WIN = 100;  // named class constant

	public static void main(String[] args) {

		Scanner keyboard = new Scanner(System.in);

		// Create two die for the game
		Die die1 = new Die();
		Die die2 = new Die();

		System.out.print("Input name of first player: ");
		String name1 = keyboard.nextLine();
		System.out.print("Input name of second player: ");
		String name2 = keyboard.nextLine();

		// Both players start with no scored points
		int score1 = 0;
		int score2 = 0;

		System.out.println("Let's play PIGGY SIX!");
		displayScores(name1, name2, score1, score2); // see helper method below

		// Pick a random player (1 or 2) to start the game
		int currentPlayer = (int)(Math.random() * 2) + 1;


		// First player to reach SCORE_TO_WIN points wins
		while (________________________________________________) {

			if (currentPlayer == 1) {
				score1 = playRound (name1, score1, die1, die2, keyboard);
				currentPlayer = 2;
			}
			else {
				score2 = playRound (name2, score2, die1, die2, keyboard);
				currentPlayer = 1;
			}

			displayScores(name1, name2, score1, score2);
			System.out.println(" ENTER to continue...");
			String userInput = keyboard.nextLine(); // used to pause program

		} // end while

		System.out.println();
		System.out.print("THE WINNER IS... ");

		// After we exit loop, one player must have at least SCORE_TO_WIN points
		if (score1 >= SCORE_TO_WIN)
			System.out.print(name1);
		else
			System.out.print(name2);

		System.out.println(" !!!!! \n");
	}

	// HELPER METHODS

	// Plays the specified players turn and updates and returns the player's
	// total score.
	public static int playRound(String name, int totalScore, 
			                    Die die1, Die die2, Scanner scan) {
		
		// Points earned while current player rolls the dice
		int points = 0;

		// Becomes true when the player is done.
		boolean playerDone = false;

		// Play until the player wants to stop the round
		while (________________________________) {

			System.out.println(name);

			int roll1 = die1.roll();
			int roll2 = die2.roll();
			displayRolls(roll1, roll2);

			if (___________________________________________) {
				// The current player rolls double sixes. The player
				// loses all points accumulated, loses all scored points,
				// and ends his/her turn.

				System.out.println("DOUBLE SIXES! You lose everything! PIGGY, PIGGY!");
				totalScore = 0;
				playerDone = true;
			}
			else if (______________________________________) {
				// The player didn't roll double sixes but rolls one six instead.
				// The player loses all points accumulated but keeps all
				// scored points, and his/her turn ends. 

				System.out.println("YOU ROLLED A SIX! Sorry! No points scored!");
				playerDone = true;  // Don't add points to totalScore
			}
			else {
				// Otherwise, the player didn't roll any sixes, so the player
				// earns the product of the roll in points. 
				// If the player wins or decides not to roll again, add the points
				// to the player's total scored points and end the player's turn.

				points = displayPointsTotal(points, roll1, roll2);  // adds to points

				if (totalScore + points >= SCORE_TO_WIN) {
					// won the game!
					playerDone = true;
				}
				else {
					// ask the user
					playerDone = !isYesAnswer("Do you wish to roll again", scan); 
				}
				
				if (playerDone){				
					// player either won or does not want to risk losing his/her points. 
					// Add points to the player's score and end this player's turn.
					totalScore += points;
				}
			}
		}
		return totalScore;  // Could we not return the totalScore, 
		                    // but use the parameter totalScore instead?
	}
	
	// Display the names and scores for the players
	public static void displayScores(String name1, String name2, int score1,
			int score2) {
		System.out.println("****************************");
		System.out.println(score1 + "\t" + name1);
		System.out.println(score2 + "\t" + name2);
		System.out.println("****************************");
	}

	// Displays the rolls of the pair of dice.
	public static void displayRolls(int roll1, int roll2) {
		System.out.print("rolls... ");
		pause();      // for suspense
		System.out.print(roll1 + " ");
		pause();
		System.out.println(roll2);
		pause();
	}

	// Displays the points earned this roll and the total this round.
	// Returns the updated total points this round.
	// Assumes the player did not roll a 6
	public static int displayPointsTotal(int points, int roll1, int roll2) {
		// The player didn't roll any sixes, so the player
		// earns the product of the roll in points
		int product = roll1 * roll2;
		System.out.println("GOOD ROLL! You just earned " + product
				+ " points.");
		points += product;
		System.out.println("Your current point total is " + points
				+ " points.");
		return points;
	}

	// Returns true if the player answers yes to the question
	// and false if the player answers no
	public static boolean isYesAnswer(String question, Scanner scan) {
		String userInput;
		char yesNoAnswer;  // first letter of answer

		boolean isBadInput;
		do {
			System.out.print(question + "? [y/n] ");
			userInput = scan.nextLine();
			if (userInput.length() == 0) {
				yesNoAnswer = 'x'; // to indicate bad input
			}
			else {
				yesNoAnswer = userInput.toLowerCase().charAt(0);
			}
			isBadInput = !(yesNoAnswer == 'y' || yesNoAnswer == 'n');
			if (isBadInput) {
				System.out.println("Please enter either yes or no");
			}
		} while (isBadInput);

		return yesNoAnswer == 'y';	
	}

    // Fake a pause by working hard
	public static void pause() {
		long i = 0;
		while (i < 100000000L) {  // NOTICE: uses long literal
			i++;
		}
	}


}
