// Demonstrates using a boolean loop control variable

import java.util.Scanner;
public class StringEqualChecker {

	// Asks the user for pairs of strings and tests whether they are equal
	public static void main(String[] args) {
		
		Scanner console = new Scanner(System.in);
		String yesNo;
		
		// repeat until the user wants to quit
		do {
			System.out.println("Enter the first string: ");
			String str1 = console.nextLine();
			System.out.println("Enter the second string: ");
			String str2 = console.nextLine();
			
			if ( areEqual (str1, str2) ) { // test our method
				System.out.println("The strings are equal.");
			} else {
				System.out.println("The strings are different.");
			}
			
			System.out.println("Test more strings? (y/n)");
			yesNo = console.nextLine();
			
		} while ( yesNo.equals("y")); 
			
	}  // end main
	
	
	// Returns true if the two strings are equal, returns false otherwise.
	public static boolean areEqual(String s1, String s2) {
		boolean equal = true;  // assume equal until can show not equal
		
		if (s1.length() != s2.length()) {
			// Lengths are not the same, so must be not equal.
			equal = false;			
		}
		else {
			// Lengths of strings are the same.
			
			// Check that characters at the each index are the same.
			int index = 0; 
			while (index < s1.length() && equal) {  
				// Note: equal is the same as (equal == true)
				
				if (s1.charAt(index) != s2.charAt(index)) {
					equal = false; 
					// need look no farther and exit while loop
				}
				else {
					// OK so far. Keep checking. Look at next index
					index++;  
				}
			}
			// exit while loop because !(index < s1.length() && equal)
			// Using deMorgan's: index >= s1.length() || !equal
			// That is, exit loop because either strings must be same, as we 
			// originally assumed or we found strings are not equal
			
		}
		
		return equal;
			
	}
		

}
