// Simulates the lineup of teams for the game Jai Alai.
// It keeps the lineup of teams in the order in which they will play as the
// the game proceeds. 
// The server is always first and the receiver is the second in the lineup.
// After each play, the loser of the match must go to the end of the line
// and the winner becomes the server for the next match.
// 
public class TeamLineup {

	private final int SERVER = 0;
	private final int RECEIVER = 1;

	private Team[] teamList;  // line of teams in the order the teams will play
	private int numTeams;     // number of teams in the lineup (for convenience)
	
	// Constructor that creates the teams and lines them up by team number
	public TeamLineup(int numberOfTeams) {
		numTeams = numberOfTeams;
		teamList = new Team[numTeams];

		// create the teams for the array and store them in numerical order
		for (int position = 0; position < numTeams; position++) {
			// First team number is 1 in the first position
			teamList[position] = new Team(position + 1);
		}
	}
	
	// Accessor that return the team that is serving the pelota
	public Team getServer() {
		return teamList[SERVER];
	}
	
	// Accessor that returns the team that is receiving
	public Team getReceiver() {
		return teamList[RECEIVER];
	}
	
	// For each match, teamList[SERVER] plays teamList[RECEIVER].
	// All other teams wait in line for their turn.
	// The winner becomes the new server and the loser goes to the end of the line.
	// Returns the winning team.
	public Team playMatch() {
		

		double randServer, randReceiver;	// numbers used to simulate competing teams'
											// play to determine a winner of each match

		// generate two unique random numbers
		randServer = Math.random();
		do	{
			randReceiver = Math.random();
		} while (randServer == randReceiver);

		// The player with the larger number is the winner					
		if (randReceiver > randServer){	
		    // receiver wins, so swap team positions
			swap();
		}
		
		rotate(); // Rotate loser to the end of list
		
		return teamList[SERVER];  // winner is now in the server position

	}
	
	// swap server and receiver, as receiver won and will be next server
	private void swap() {
		Team winner = teamList[RECEIVER];
		teamList[__________] = teamList[_______________];
		teamList[__________] = winner;
	}

	// Rotate the loser to the end of the list
	private void rotate() {
		// Assumes winner of match is in position SERVER of array
		// and loser of match is in position RECEIVER of array
	
		// Will move loser to the end of the list after shift
		Team loser = teamList[RECEIVER];

		// Move up waiting teams one position by shifting them 
		// one position closer to the front of the array
		for (int from = ____________; from < ___________; from++)	{
			    // to <= from
				teamList[__________] = teamList[from];			
		}
		
		// Place loser of match at the end of waiting line
		teamList[_____________] = loser;
	}

	// returns the scoreboard, the status of each team in lineup
	public String toString() {
		String scoreboard = "";
		for (int position = 0; position < numTeams; position++)	{
			scoreboard += teamList[position] + "\n"; // invokes toString() - why? which one?
		}
		return scoreboard;
	}


}