/* Simulates the game Jai Alai.  In this version there are 6 teams.
 * Teams line up in the order 1,2,3,4,5,6  The game begins with team 1 
 * serving the ball to team 2. The winning team scores one point and 
 * stays on the court to meet the next team in rotation. The losing 
 * team goes to the end of the line to wait for another turn. After 
 * all teams have played once, the point value doubles.  The first 
 * team to reach seven (or nine) points wins the game.
 * 
 * Originally by Tom Cortina
 * Modified by Margaret Reid-Miller
 * 
 */
import java.util.Scanner;

public class JaiAlai {
	
	public static void main(String[] args) 
					throws InterruptedException	{ // needed by Thread.sleep()
		
		final int NUM_TEAMS = 6;
		final int WINNING_SCORE = 7;
		
		Scanner console = new Scanner(System.in);
		
		// Create NUM_TEAMS teams numbered 1, 2, 3, ... and line them up.  		
		TeamLineup lineup = new TeamLineup(NUM_TEAMS);
		Team winner;
		
		System.out.println();
		System.out.println("LET'S PLAY JAI ALAI!");
		System.out.println();
		Thread.sleep(2000);   // pause 2 seconds
		
		// Show the initial score for each team in the lineup
		System.out.println(lineup.toString());  // which toString?
		System.out.println("Press ENTER to see first match...");
		String userInput = console.nextLine();
		
		int numMatches = 1;     // start with first match
		int matchValue = 1;		// each match is worth 1 point initially
		
		// play matches until the game is over
		boolean gameOver = false;
		do {

			// print server's team number and receiver's team number
			System.out.println("Team " + lineup.____________________________________ 
				  + " serves to Team " + lineup.____________________________________ + " ...");
			// The first two teams in the lineup play a match.
			// Loser goes to the end of the line.
			winner = lineup.playMatch();  // What type is winner?
			printWinner(winner);  // where is this method?

			// add to the winner's points and display the new score board 		
			winner.__________________________;
			System.out.println(lineup);  // which method is called?
				
			// check to see if winner has reach winning score
			gameOver = (winner.____________________ >= WINNING_SCORE);
			
			if (!gameOver) {  // get ready for next match
				numMatches++;
			
				// after each team has played once, the match value doubles			
				if (numMatches == NUM_TEAMS)	{
					System.out.println();
					System.out.println("---MATCH POINT VALUES DOUBLE---");
					System.out.println();
					Thread.sleep(6000);  // pause 6 seconds
					matchValue = 2;
				}	
				
				System.out.println("Press ENTER to see next match...");
				userInput = console.nextLine();
			}
		} while (!gameOver);
		
		System.out.println();
		System.out.println("******************* TEAM " + winner.getTeamNumber() 
			+ " WINS THE GAME!!! *******************");
		System.out.println();

	}
	
	public static void printWinner(Team winner) throws InterruptedException	{
			Thread.sleep(2000);		// for suspense 
			System.out.println("Team " + winner.getTeamNumber() 
				+ " wins match.");
			System.out.println();
			Thread.sleep(2000);		// for cheers and boos

	}
	
}