
public class GiftCardEqualsTester{

	public static void main(String[] args) {
		
		System.out.println ("Alice buys a $100.00 gift card from Macy's");
		GiftCard alice = new GiftCard("Macy's", 100.0);

		System.out.println("Sue buys a $100.00 gift card from Macy's");
		GiftCard sue = new GiftCard("Macy's", 100.0);
		System.out.println("Alice: " + alice);
		System.out.println("Sue:   " + sue);
		printEquality(alice, "alice", sue, "sue");

		System.out.println("Sue adds $25.00 to her Macy's gift card");
		sue.addMoney(25.0);
		System.out.println("Alice: " + alice);
		System.out.println("Sue:   " + sue);
		printEquality(alice, "alice", sue, "sue");

		System.out.println("Bob borrows Alice's card");
		GiftCard bob = alice;
		System.out.println("Bob:   " + bob);
		System.out.println("Alice: " + alice);
		printEquality(bob, "bob", alice, "alice");
		
		System.out.println("Bob spends $50.00 using his Macy's card.");
		bob.buyGoods(50.0);
		System.out.println("Bob:   " + bob);
		System.out.println("Alice: " + alice);
		printEquality(bob, "bob", alice, "alice");
	
		System.out.println("Alice buys a $75.00 gift card from Target");
		alice = new GiftCard("Target", 75.0);
		System.out.println("Bob:   " + bob);
		System.out.println("Alice: " + alice);
		printEquality(bob, "bob", alice, "alice");
		

	}
	
	public static void printEquality(GiftCard gc1, String name1, 
										GiftCard gc2, String name2) {
		if (gc1 == gc2) {
			System.out.println(name1+" == "+name2+": "+name1+" and "+
					name2+" share the same (identical) card.");
		} else if (gc1.equals(gc2)) {
			System.out.println(name1+".equals("+name2+"): "+name1+" and "+
					name2+" have two gift cardsthat appear the same (same content)");
		} else {
			System.out.println(name1+" and "+name2+" have different gift cards.");
		}
		System.out.println();
	
	
	}

}
