/*
 * A gift card for a store has a store name and balance (in dollars) 
 */
public class GiftCard {
	//---------------------
	// Fields
	//---------------------
	private String store;   // The store at which the gift card can be used.
	private double balance; // Amount remaining on the card (in dollars)

	//---------------------
	// Constructor
	//---------------------
	
	// Constructs a card for the specified store with the 
	// specified amount of dollars
	public GiftCard(String storeName, double amount) {
		store = storeName;
		balance = amount;		
	}

	//---------------------
	// Mutators
	//---------------------
	
	// If there is a sufficient balance then deduct the price from
	// the balance.  Otherwise, deduct what balance there is.
	public void buyGoods(double price) {
		if (balance >= price) {
			balance = balance - price;
		} else {
			balance = 0;
		}		
	}
	
	// Add the specified amount to the balance
	public void addMoney(double amount) {
		balance = balance + amount;
	}

	//---------------------
	// Accessors
	//---------------------
	
	// Return the card's balance
	public double getBalance() {
		return balance;
	}
	
	// Return the store for which the card was purchased
	public String getStore() {
		return store;
	}
	
	// Return a string that represents the card
	public String toString() {
		return store + " gift card with a balance of $" 
				+ balance;
	}
	
	// Returns true if the store and balance are the same for
	// this card and the specified other card.
	public boolean equals(GiftCard otherCard) {
		return this.store.equals(otherCard.store) &&
		       this.balance == otherCard.balance;
	}

}
