
public class Elevator {

	private int topFloor;       // maximum floor number
	private int currentFloor;		
	private int capacity;       // max number of riders
	private int numRiders;

	public Elevator(int numberOfFloors, 
			int maxRiders) {
		topFloor = numberOfFloors;
		currentFloor = 1;  // Starting floor
		capacity = maxRiders;
		numRiders = 0;     // Initially empty
	}

	public Elevator(int numberOfFloors) {
		topFloor = numberOfFloors;
		currentFloor = 1;  // Starting floor
		capacity = 12;     // Standard capacity
		numRiders = 0; 	   // Initially empty
	}

	public int getNumRiders() {
		return numRiders;
	}

	public int getCurrentFloor() {
		return currentFloor;
	}

	public boolean isFull() {
		return numRiders == capacity;
	}

	public void addRiders(int numRequestingToEnter) {
		if (numRiders + numRequestingToEnter <= capacity) {
			numRiders = numRiders + numRequestingToEnter;
		} 
		else {
			numRiders = capacity;
		}
	}

	public void goUpOneFloor() {
		if (currentFloor < topFloor) 
			currentFloor++;
	}
	
	public String toString() {
		return "current floor = " + currentFloor 
			+ " top floor = " + topFloor 
			+ "\nnumber of riders = " 
			+ numRiders
			+ " capacity = " + capacity;
	}

	public boolean equals(Elevator other) {
		return topFloor == other.topFloor 
			&& currentFloor == other.currentFloor
			&&	capacity == other.capacity
			&&	numRiders == other.numRiders;
	}

}
