/*
 * Models a die, a multisided object that has faces showing the numbers 
 * from 1 to the number of faces.
 */
public class Die {
	
    //--------------------------------------------------------------	
	// Fields (instance variables): Each instance of the class (an object) 
	// has memory allocated to store values in all the fields.
    //--------------------------------------------------------------	
    // Since the variables are declared at the class level (not in any method),
	// they are visible to any method of the class.
	private int numSides;    // number of sides (maximum face value)
	private int faceValue;   // current value of the upper face
	
    //--------------------------------------------------------------	
	// CONSTRUCTORS: A constructor should initialize all the fields
    //--------------------------------------------------------------	
	
	public Die() {
		numSides = 6;   // typically a die has 6 sides
		faceValue = 1;  // arbitrarily set 1 face up
	}

	// Overloads the constructor: has a parameter for the number of sides
	public Die(int numberOfSides) {
		numSides = numberOfSides;
		faceValue = 1;
	}

    //--------------------------------------------------------------	
	// BEHAVIORS: Each behavior should do one operation
    //--------------------------------------------------------------	
		
	// Mutator: rolls the die.
	public void roll() {
		// Generate a random number between 1 and numSides
		faceValue = (int) (Math.random()*numSides) + 1; 
	}

	// Face value accessor: returns the face value of the die
	public int getFaceValue() {
		return faceValue;  // Returns the current face value of the  
		                   // die to the calling method.
	}

	// Face value mutator: sets the face value of the die
	public void setFaceValue(int value) {
		faceValue = value;  // Turn the die so value is the upper face
	}

	// Returns a string representation of this die.
	//
	// NOTE: toString method must have the signature as shown.
	// Usually used for debugging purposes
	public String toString() {
		String dieAsString = numSides + "-sided with " 
			+ faceValue + " facing up";
		return dieAsString; 
	}
}
 