/*
 * Illustrates object-oriented programming using a simple user-defined class
 * Author: Margaret Reid-Miller
 */
public class DiceRoller {
	
	// Creates two Die objects and rolls two dice

	public static void main(String[] args) {
		
		// Declare a die object reference.  No die object created yet!
		Die die1;  
		
		// Instantiate (create) a die object using the constructor
		die1 = new Die();
		
		// Declare and instantiate a second die object using a different constructor
		Die die2 = new Die(6); 
		
		System.out.println("Rolling the two dice.");
		die1.roll();  
		die2.roll();
		
		// Get the results of the rolls
		int roll1 = die1.getFaceValue();
		int roll2 = die2.getFaceValue();
				
		System.out.println("Face value of die 1: " + roll1);
		System.out.println("Face value of die 2: " + roll2);

		// 
		int total = roll1 + roll2;
		System.out.println("The total is " + total + ".");
		System.out.println();  // print a blank line

		System.out.println("Rolling the two dice a second time.");
		die1.roll();
		die2.roll();

		System.out.println("die1: " + die1.toString());  
		System.out.println("die2: " + die2.toString()); 

		total = die1.getFaceValue() + die2.getFaceValue();
		System.out.println("The total is " + total + ".");
		System.out.println();
	
		System.out.println("Turn dice to show cat's eyes.");
		die1.setFaceValue(1);
		die2.setFaceValue(1);
		
		System.out.println("die1: " + die1);  // invokes toString()
		System.out.println("die2: " + die2);  // invokes toString()


	}

}
