//Sample program that analyzes the number of bacteria colonies on 
//petri dishes specified in a file. Reports the maximum, minimum, 
//and average number of colonies.

import java.util.Scanner;		// imports Scanner class
import java.io.File;			// imports File class
import java.io.IOException;		// imports IOException class
public class BacteriaColoniesAnalyzer
{

	public static void main(String[] args)  throws IOException {

		// Get the name of the file with the bacterial data from the user.
		Scanner console = new Scanner(System.in);
		System.out.println("Please enter the file name with " +
		"the numbers of bacterial colonies: ");
		String fileName = console.nextLine();

		// Create a new Scanner object to read from the this file
		Scanner fileToRead = new Scanner(new File(fileName));
		// First line of the file is the number of data values in the file
		int numDishes = fileToRead.nextInt();
		// Use this number to create an array of that size
		int[] numColonies = new int[numDishes]; 

		// Read numCounts data values from the file
		for (int index = 0; index < numDishes; index++) {
			numColonies[index] = fileToRead.nextInt();
		}

		// output statistics about the bacteria counts
		System.out.println();
		System.out.println("BACTERIA COUNT ANALYSIS");
		System.out.println("Number of samples: " + numDishes);
		double average = computeAverage(numColonies);
		System.out.println("Average: " + average);
		System.out.println("Number above average: " 
				+ countNumAboveAverage(numColonies));
		System.out.println("Minimum: " + findMinimum(numColonies));
		System.out.println("Maximum: " + findMaximum(numColonies));

	}

	// Precondition: There is at least one data value
	// Returns the average of the specified data.
	public static double computeAverage(int[] data) {
		int sum = 0;

		for (int i = 0; i < data.length; i++) {
			sum = sum + data[i];
		}
		return (double) sum / data.length;
	}

	// Returns the number of the specified data that are 
	// greater than the the average.
	public static int countNumAboveAverage(int[] data) {
		int numAbove = 0;

		if (data.length > 0) {  
			// data meets the precondition for computeAverage
			double average = computeAverage(data);
			
			// for each element in data count those above average
			for (int i = 1; i < data.length; i++) {
				if (data[i] > average) {
					numAbove++;
				}
			}
		}

		return numAbove;
	}	

//	Precondition: There is at least one data value
//	Returns the minimum of the specified data.
	public static int findMinimum(int[] data) {
		int minSoFar = data[0];

		// for each element, check next element should be new minimum
		for (int i = 1; i < data.length; i++) {
			if (data[i] < minSoFar) {
				minSoFar = data[i];
			}
		}
		return minSoFar;
	}


//	Precondition: There is at least one data value
//	Returns the maximum of the specified data.
	public static int findMaximum(int[] data) {
		int maxSoFar = data[0];

		// for each element, check next element should be new maximum
		for (int i = 1; i < data.length; i++) {
			if (data[i] > maxSoFar) {
				maxSoFar = data[i];
			}
		}
		return maxSoFar;
	}

}
