function y = vdpol(t,y,mu)
%VDPEX	Van der Pol equation in relaxation oscillation.
%	The parameters here were specified by Shampine.  The limit cycle has
%	portions where the solution components change slowly and the problem
%	is quite stiff alternating with regions of very sharp change,
%	quasi-discontinuities, where it is not stiff.  The initial
%	conditions are close to a portion of slow change so as to test
%	schemes for the selection of the initial step size.
%	
%	 Evaluation of a test set for stiff ODE solvers, 
%	
%	
%	

%if length(t) == 0 			% return default tspan, y0 and options
 % out1 = [0; 3000];
 % out2 = [2; 0];
 % out3 = odeset('vectorized');
 % return;
%end

dy = zeros(size(y)); 			% preallocate vector dy

dy(1,:) = y(2,:);

dy(2,:) = mu*(1 - y(1,:).^2).*y(2,:) - y(1,:);

y = dy;
