% gpsdemo.m

load gps_data;

disp('The SV coordinate matrix in ECEF parameters, and SV time, are');
SV_matrix
disp('Hit any key to continue...');
pause;

disp('The satellite pseudoranges (in meters) are');
P
disp('Hit any key to continue...');
pause;

disp('The receiver position estimate in ECEF XYZ is');
R_est
disp('Hit any key to continue...');
pause;

disp('Now the corrected position and time bias will be calculated...');
disp('Hit any key to continue...');
pause;

[R,GDOP,PDOP,TDOP] = gpspos(SV_matrix,P,R_est);

disp('The corrected position and time bias are:');
R
disp('Hit any key to continue...');
pause;

disp('The difference between the estimated position and the calculated position is:');
for ctr1=1:3
    diff(ctr1)=[R(ctr1)-R_est(ctr1)];
end
diff

disp('The DOPs are:');
GDOP
PDOP
TDOP