signature UNION_FIND =
  sig

    (* Implements the famous union find algorithm for merging finite disjoint
       sets.  Very useful for constructing equivalence relations by defining
       their equivalence classes as sets, and merging sets by putting two
       representatives in the same class.

       Note, that most of the functions destructively modify the collection,
       even the lookup ones like `sameSubset. *)


    (* Raised when an element is expected to be in the collection and is not
       (in the sameSubset and mergeSubset functions). *)
    exception UnionFindError of string

    type 'a Collection

    (* Create a new collection.  For technical reasons, it needs two
       functions: an equality on your values, and a function computing their
       string representations *)

    val makeCollection: ('a * 'a -> bool) * ('a -> string) -> 'a Collection
    (* Add an element as a new singleton set to the collection, if not already there. *)
    val addToCollection: 'a Collection -> 'a -> unit
    (* Check if two elements are in the same set in the collection *)
    val sameSubset: 'a Collection -> 'a * 'a -> bool
    (* Merge two subsets to which the two elements belong *)
    val mergeSubsets: 'a Collection -> 'a * 'a -> unit

    (* Return the entire collection as a list of lists of elements, each list
       representing a set. *)

    val listCollection: 'a Collection -> 'a list list
  end
