(* Module for doing time profile on NON-RECURSIVE functions.

   Recursive functions will confuse this statistics a lot, as it
   relies on the assumption that the data for each function is updated
   before the timer is restarted.  Nested functions with different
   names are OK. *)

signature TIMING_STAT =
  sig
    type CPUtimer

    (* Run this function at the beginning of a function and save its output *)
    val startTimer: string -> CPUtimer

    (* Run this function at the very end of a function and give it the
       value `startTimer' returned at the beginning *)
    val updateStat: CPUtimer -> unit

    (* This will generate a nicely printable string with all the statistics collected so far *)
    val stat2string: unit -> string

    (* Forget all the statistics collected *)
    val resetStat: unit -> unit
  end
