signature STR =
  sig
    datatype Str = Str of string | Conc of Str * Str

    val Str2string: Str -> string
    val strlist2str: string -> string list -> string
    val Strlist2Str: string -> Str list -> Str
    val bool2str: bool -> string
    (* Some convenient functions for optional arguments *)
    val option2Str: Str -> Str option -> Str
    val option2string: string -> string option -> string
    (* Run the function on the value or return the `default' one if
       the value is NONE.
       Useful for converting optional values to strings. *)
    val optionPrint: ('a -> 'b) -> 'b -> ('a option) -> 'b
  end
