(* Definition of a type for the status file representation.  The
   entire file is represented by a list of SFsection entries. *)

signature STATUS_FILE_STRUCT =
  sig
    (* SFfield(name, value) - the `name' attribute gets `value' string *)
    datatype StatusFileField = SFfield of string * string
    (* Section type and its list of assignments *)
    datatype StatusFileSection = 
	SFsection of string * (StatusFileField list)
    (* Representation of the status file *)    
    type StatusFileType = StatusFileSection list
  end
