(* Parser of the status file format for the SyMP prover *)

structure StatusFileStruct = StatusFileStruct
structure ParseError = ParseError
open StatusFileStruct
open ParseError

fun joinstr [] = ""
  | joinstr [s] = s
  | joinstr (s::lst) = s^" "^(joinstr lst)

%%

%name StatusFile


%verbose
%pure
%header (functor StatusFileLrValsFun
           (structure Token : TOKEN
            structure ParseError: PARSE_ERROR
            structure StatusFileStruct: STATUS_FILE_STRUCT)
  : sig structure ParserData : PARSER_DATA
            where type result = StatusFileStruct.StatusFileType;
        structure Tokens : StatusFile_TOKENS
   end)

%eop EOF
%pos int
%noshift EOF

%term 
  STRING of string
| SYMBOL of string
| EOL
| EQ
| LB
| RB
| EOF

%nonassoc EQ
%nonassoc EOL STRING SYMBOL LB RB EOF

%nonterm begin of StatusFileType
| eol
| sections of StatusFileType
| section of StatusFileSection
| assts of StatusFileField list
| asst of StatusFileField
| str of string
| strings of string list

%start begin

%%

begin       : sections (sections)
eol         : EOL ()
            | EOL eol ()
sections    : ([])
            | section sections (section::sections)
section     : LB strings RB eol assts (SFsection(joinstr(strings),assts))
assts       : ([])
            | asst eol assts (asst::assts)
asst        : SYMBOL EQ strings (SFfield(SYMBOL,joinstr(strings)))
strings     : ([])
            | str strings (str::strings)
str         : STRING (STRING)
            | SYMBOL (SYMBOL)
            | EQ str ("=")
