(* Signature for status file handling module *)

signature STATUS_FILE =
  sig
    structure StatusFileStruct: STATUS_FILE_STRUCT
    type StatusFileType = StatusFileStruct.StatusFileType

    val StatusFile2str: StatusFileType -> Str.Str

    (* These functions may raise SympError exception when file cannot be read or written *)

    (*  writeStatusFile(filename, status) *)
    val writeStatusFile: string -> StatusFileType -> unit
    (* readStatusFile(filename) *)
    val readStatusFile: string -> StatusFileType
  end
