(* This is an abstract interface to the structure with basic type
   definitions for a proof system.  It is separate from the main
   Sequent module because we want to define other standard typed and
   functions for inference rules that use these types. *)

signature SEQUENT_BASE =
  sig
    structure InputLanguage: INPUT_LANGUAGE

    type Sequent
    type SequentPart

    (* Some hints of what a sequent should look like, so that subgoals
       in a proof tree can be matched better when the theorem changes.
       Currently, the hints are added only by the internal functions
       like rule application, etc. *)

    type SequentHints

    (* Pretty printing *)
    val formulaInd2str: SequentPart * (int option) -> string
    val sequent2string: Sequent -> string
    val sequent2str: Sequent -> Str.Str

    val hints2string: SequentHints -> string

  end
