(* Signature for parse tree of the proof tree.  Its implementation is
   local to the ProofTree module. *)

signature PROOF_TREE_STRUCT =
  sig
    datatype ProofTreeType =
	PTsymbol of string
      | PTstring of string
      | PTnumber of int
      | PTlist of ProofTreeType list
      (* For named rule's arguments *)
      | PTassoc of string * ProofTreeType
      (* The name of the rule and the list of arguments *)
      | PTrule of string * (ProofTreeType list)
      | PTsubgoalID of string * (int list)
      (* PTchild(subgoalID, optional-hints) *)
      | PTchild of ProofTreeType * (string option)
      (* The entire subgoal entry with ID, rule and children; the last two are optional *)
      | PTsubgoal of ProofTreeType * (ProofTreeType option) * (ProofTreeType list option)
      (* The entire proof *)
      | PTproof of ProofTreeType list
  end
