structure Tokens = Tokens
structure ParseError = ParseError
open ParseError

type pos = int
type svalue = Tokens.svalue
type ('a, 'b) token = ('a, 'b) Tokens.token
type lexresult= (svalue, int) token
type arg = string * pos * pos -> unit

val pos = ref 1
val yypos_bol = ref 0  (* remember the val. of yypos at the
			  beginning of the current line *)

val eof = fn _ => Tokens.EOF((!pos,0))
(* val error = fn (e,l,c) => (wasError := true;
			   print("at "^(Int.toString l)^"."
				 ^(Int.toString c)^": "^e^"\n"))
 *)

fun incLine (x: int ref) =  (x := !x + 1)

(* Strip quotes surrounding the string, and process the backslash escape sequences *)
fun ripQuotes str = 
    let val chars = String.explode (String.extract(str,1,SOME(String.size(str)-2)))
        fun loop [] = []
          | loop ((#"\\")::(#"n")::lst) = #"\n"::(loop lst)
          | loop ((#"\\")::(#"t")::lst) = #"\t"::(loop lst)
          | loop ((#"\\")::(#"r")::lst) = #"\r"::(loop lst)
          | loop ((#"\\")::c::lst) = c::(loop lst)
	  | loop (c::lst) = c::(loop lst)
    in String.implode(loop chars)
    end

fun id2token(s,pos,line) =
    let fun keyword x = NONE
    in
	case keyword(s) of
	    SOME x => x
	  | NONE => Tokens.SYMBOL(s,pos,line)
    end

%%

%arg (error);
%header (functor ProofTreeLexFun(structure Tokens: ProofTree_TOKENS
			         structure ParseError: PARSE_ERROR));

alpha=[-A-Za-z_+*/?];
idchar=[-A-Za-z_0-9?\'+*/<>];
digit=[0-9];
comment = ";".*\n;

%%

\n           => (yypos_bol := yypos; incLine pos; continue());
{comment}    => (yypos_bol := yypos; incLine pos; continue());
"("          => (Tokens.LP(!pos,yypos - !yypos_bol));
")"          => (Tokens.RP(!pos,yypos - !yypos_bol));
"["          => (Tokens.LB(!pos,yypos - !yypos_bol));
"]"          => (Tokens.RB(!pos,yypos - !yypos_bol));
"."          => (Tokens.DOT(!pos,yypos - !yypos_bol));
","          => (Tokens.COMMA(!pos,yypos - !yypos_bol));
"="          => (Tokens.EQ(!pos,yypos - !yypos_bol));
{digit}+     => (Tokens.NUMBER ((List.foldl (fn(a,r)=>ord(a)-ord(#"0")+10*r)
					  0 (explode yytext)),
				!pos,yypos - !yypos_bol));
{alpha}{idchar}* => (id2token(yytext,!pos,yypos - !yypos_bol));
\"([^\"]|\\.)*\"   => (Tokens.STRING((ripQuotes yytext),!pos,yypos - !yypos_bol));
.            => (continue());
