#include <stdio.h>
#include <strings.h>

/* Generate <program_name>.{sig,sml}, where <program_name> is the
   actual name of the executable. */

/* Number of fields in the record */
#define N 7
#define SIGNAME "OPTIONS"
#define TYPENAME "options"
#define FUNNAME "OptionsFun()"

#define DECLARATIONS "datatype UserInterface = commandLine | Emacs
"

char *fields[] = {"verbose", /* verbose mode */
		  "interface",   /* which user interface to use */
		  "debug",   /* Turn on debugging messages for specified functions */
		  "spec",    /* Theorems to prove.  Makes sense only in command line mode. */
		  "limit",   /* Type size threshold after which it's considered "infinite" */
		  "backendMC", /* Name of the back-end model checker */
		  "outputFile" /* Output file name. Makes sense only in command line mode. */
                };
char *types[] = {"bool",
		 "UserInterface",
		 "string list option",
		 "string list",
		 "int",
		 "string",
		 "string"};

char *defaults[] = {"false",
		    "commandLine",
		    "NONE",
		    "[]",
		    "20",
		    "\"smv\"",
		    "\"out.smv\""};

int main(argc,argv)
int argc;
char **argv;
{
  FILE *ff;
  int i,j;
  char filename[256];

  if(argc!=2) {
    fprintf(stderr,"%s: one argument required, -sig or -sml.\n",argv[0]);
    exit(1);
  }
  
  if(!strcmp(argv[1],"-sig")) {
    /* Generate the .sig file */
    strcpy(filename,argv[0]);
    strcat(filename,".sig");
    if(!(ff=fopen(filename,"w"))) {
      fprintf(stderr,"Error: cannot open file %s.\n",filename);
      exit(1);
    }
    fprintf(ff,"(* This file is automatically generated by `options.c'.
   Do not edit it manually. *)\n\n");
    fprintf(ff,"signature %s =
  sig
    %s
    type %s = 
      { ",SIGNAME, DECLARATIONS, TYPENAME);
    for(i = 0; i < N; i++) {
      fprintf(ff,"%s: %s",fields[i],types[i]);
      if(i < N-1) fprintf(ff,",\n        ");
    }
    fprintf(ff," }\n\n");
    fprintf(ff,"    val defaultOptions: options\n\n");
    fprintf(ff,"    (* Updating the options' fields *)\n");
    for(i = 0; i < N; i++)
      fprintf(ff,"    val upd_%s: %s * (%s) -> %s\n",
	      fields[i],TYPENAME,types[i],TYPENAME);
    fprintf(ff,"\n\n    (* Extracting the options' fields *)\n");
    for(i = 0; i < N; i++)
      fprintf(ff,"    val get_%s: %s -> %s\n",
	      fields[i],TYPENAME,types[i]);
    fprintf(ff,"  end\n");
    fclose(ff);
  } else if(!strcmp(argv[1],"-sml")) {
    /* Generate the .sml file */
    strcpy(filename,argv[0]);
    strcat(filename,".sml");
    if(!(ff=fopen(filename,"w"))) {
      fprintf(stderr,"Error: cannot open file %s.\n",filename);
      exit(1);
    }
    fprintf(ff,"(* This file is automatically generated by `options.c'.
   Do not edit it manually. *)\n\n");
    fprintf(ff,"functor %s: %s =
  struct
    %s
    type %s = 
      { ",FUNNAME, SIGNAME, DECLARATIONS, TYPENAME);
    for(i = 0; i < N; i++) {
      fprintf(ff,"%s: %s",fields[i],types[i]);
      if(i < N-1) fprintf(ff,",\n        ");
    }
    fprintf(ff," }\n\n");
    fprintf(ff,"    val defaultOptions: options = {\n");
    for(i = 0; i < N; i++)
      fprintf(ff,"          %s = %s%s\n",fields[i],defaults[i],(i<N-1)? "," : " }\n\n");
    fprintf(ff,"    (* Updating the options' fields *)\n");
    for(i = 0; i < N; i++) {
      fprintf(ff,"    fun upd_%s(%s: %s, value) =\n",
	      fields[i],TYPENAME,TYPENAME);
      fprintf(ff,"      let val { ");
      for(j = 0; j < N; j++) {
	fprintf(ff,"%s = %s",fields[j],fields[j]);
	if(j < N-1) fprintf(ff,",\n                ");
      }
      fprintf(ff," } = %s\n",TYPENAME);
      fprintf(ff,"      in { ");
      for(j = 0; j < N; j++) {
	fprintf(ff,"%s = %s",fields[j],(i == j)? "value" : fields[j]);
	if(j < N-1) fprintf(ff,",\n           ");
      }
      fprintf(ff," }\n      end\n\n",TYPENAME);
    }
    fprintf(ff,"    (* Extracting the options' fields *)\n");
    for(i = 0; i < N; i++)
      fprintf(ff,"    fun get_%s({ %s = %s, ...}: %s) = %s\n",
	      fields[i], fields[i], fields[i], TYPENAME, fields[i]);
    fprintf(ff,"  end\n");
    fclose(ff);
  }
}
