structure ListOps: LIST_OPS =
  struct

    open SympBug

    (* Commonly used list functions *)
    fun zip(h1::l1,h2::l2) = (h1,h2)::(zip(l1,l2))
      | zip([],[]) = []
      | zip(_,_) = raise SympBug("ListOps/zip: lists are not the same size")

    fun zipOpt ([],[]) = SOME []
      | zipOpt (x1::l1, x2::l2) = Option.map(fn l=>(x1,x2)::l)(zipOpt(l1,l2))
      | zipOpt _ = NONE

    fun union _ [] = []
      | union _ [l] = l
      | union eqf (h::t) = 
      let 
	val U = union eqf t
      in
	(List.filter (fn x => not (List.exists (fn y => eqf (x, y)) U)) h) @ U
      end

    fun subtract _ ([], _) = []
      | subtract eq (el::l1, l2) =
	  if List.exists(fn x=> eq(el, x)) l2 then
	      subtract eq (l1, l2)
	  else el::(subtract eq (l1, l2))

    (* Given an n-list of lists of values, return a list of
       n-lists of all combinations of those values. *)
    fun comblist [] = [[]]
      | comblist (hd::tl) =
	let val lst = comblist tl
	    fun ff x = List.map(fn l=>x::l) lst
	in List.foldr(op @) [] (List.map ff hd)
	end
  end
