signature INTERACT =
  sig
    structure Interface: INTERFACE

    type options = Interface.Options.options
    type UserInput = Interface.UserInput

    (* Initialize the tool.  This, in particular, sets the options. *)
    val initSymp: options -> unit

    (* Everything is reset, except options *)
    val ResetSympState: unit -> unit

    (* Record current options in a state, so we can change them on-the-fly.
       Since InitSymp sets the initial options, no need to run it at the startup. *)
    val setOptions: options -> unit
    val getOptions: unit -> options

    (* Execute the list of user commands until the first error (exception).
       If there were no errors, return true, otherwise false. *)

    val tryExecuteList: UserInput list -> bool

    (* Read user inputs and executes the commands in an endless loop.
       This function never returns.  It raises the SympExit exception
       to perform a clean exit, or SympError on some fatal error. *)

    val readExecLoop: unit -> unit

  end
