signature HASH =
  sig

      (* Abstract type of a hash object parameterized by types of
         lookup keys and values *)
    type ('a, 'b) Hash 

    (* makeHashCustom(eq,size,F,resizable) takes equality function,
       initial size, the hash function F, and the flag indicating
       whether the hash can be resized (e.g. if F depends on the size,
       the hash cannot be resizable). *)

    val makeHashCustom: ('a * 'a -> bool) * int * ('a -> int) * bool -> ('a, 'b) Hash
    (* makeHash(eq) will return a new (empty) hash object. *)
    val makeHash: ('a * 'a -> bool) -> ('a, 'b) Hash
    val makeHashDefault: ('a * 'a -> bool) * ('a -> string) -> ('a, 'b) Hash
    val findHash: ('a, 'b) Hash * 'a -> 'b option
    val insertHash: ('a, 'b) Hash * 'a * 'b -> ('a, 'b) Hash
    (* Fast and dirty variant of the above *)
    val insertHashDestructive: ('a, 'b) Hash * 'a * 'b -> ('a, 'b) Hash
    val removeHash: ('a, 'b) Hash * 'a -> ('a, 'b) Hash
    val removeHashDestructive: ('a, 'b) Hash * 'a -> ('a, 'b) Hash
    val wipeHash: ('a, 'b) Hash -> ('a, 'b) Hash
    val wipeHashDestructive: ('a, 'b) Hash -> ('a, 'b) Hash
    val copyHash: ('a, 'b) Hash -> ('a, 'b) Hash

   (* This will probably go away eventually. Takes two functions that
      convert key and element values into 'c and 'd (usually strings),
      and a hash table, and produces the list of pairs of that type
      for all entries in the hash. *)

    val hash2any: ('a -> 'c) -> ('b -> 'd) -> ('a,'b) Hash -> ('c * 'd) list

   (* Returns the list of integers representing the number of elements
    in each hash table entry.  Mostly for debugging and evaluating
    purposes. *)
    val stats: ('a,'b) Hash -> int list

  end
