(* Parser of emacs output for the SyMP emacs server *)

structure EmacsServerStruct = EmacsServerStruct
structure ParseError = ParseError
open EmacsServerStruct
open ParseError

%%

%name EmacsServer


%verbose
%pure
%header (functor EmacsServerLrValsFun
           (structure Token : TOKEN
            structure ParseError: PARSE_ERROR
            structure EmacsServerStruct: EMACS_SERVER)
  : sig structure ParserData : PARSER_DATA
            where type result = EmacsServerStruct.EmacsExpr;
        structure Tokens : EmacsServer_TOKENS
   end)

%eop EOF WS
%pos int
%noshift EOF

%term 
  STRING of string
| SYMBOL of string
| NIL
| TRUE
| DOT
| NUMBER of int
| LP
| RP
| EOF
| WS

%nonassoc WS
%nonassoc STRING SYMBOL NIL DOT NUMBER TRUE
%nonassoc LP RP EOF

%nonterm begin of EmacsExpr
| expr of EmacsExpr
| exprlist of EmacsExpr 
| ws


%start begin

%%

begin       : ws expr (expr)
ws          : %prec LP ()
            | WS ws ()
expr        : STRING (EmacsString(STRING))
            | SYMBOL (EmacsSymbol(SYMBOL))
            | NIL    (EmacsNil)
            | TRUE   (EmacsTrue)
            | NUMBER (EmacsNumber(NUMBER))
            | LP ws exprlist RP (exprlist)
exprlist    : expr ws DOT ws expr (EmacsCons(expr1,expr2))
            | expr ws exprlist (EmacsCons(expr,exprlist))
            | expr ws (EmacsCons(expr,EmacsNil))
