signature EMACS_SERVER_INTERFACE =
  sig
    structure EmacsServerStruct: EMACS_SERVER

    exception EmacsServerError of string

    type EmacsExpr = EmacsServerStruct.EmacsExpr

    (* Convert a list of emacs expressions into a list as an emacs expr *)
    val EmacsList: EmacsExpr list -> EmacsExpr

    val EmacsExpr2str: EmacsExpr -> Str.Str
    val EmacsExpr2string: EmacsExpr -> string

    (* Same as above, only wrap the entire expression into special delimiters *)
    val EmacsExpr2strServer: EmacsExpr -> Str.Str
    val EmacsExpr2stringServer: EmacsExpr -> string

    val EmacsExprParse: TextIO.instream -> EmacsExpr

  end
