;;;; Major mode for writing SyMP programs.

;;;; For now it is a gently hacked version of smv-mode.el.

;;;; Sergey Berezin, Dec. 1998. Send bugs and suggestions to 
;;;; sergey.berezin@cs.cmu.edu
;;;;
;;;; This file can be used and modified freely.

;;;; This library provides an emacs interface to SYMP. The main
;;;; features are fontification (xemacs or gnu-emacs >= 19.30), and
;;;; nothing else yet, since there is no any tool to support the
;;;; language so far.

;;;; To use this library, place the following lines into your ~/.emacs file:
;;;;
;;;; ;;; SyMP mode
;;;; (autoload 'symp-mode "symp-mode" "SyMP specifications editing mode." t)
;;;; (add-to-list 'auto-mode-alist '("\\.symp$" . symp-mode))
;;;;
;;;; Of course, the file symp-mode.el must be in one of the directories in your
;;;; `load-path'. C-h v load-path to see the list, or `cons' your own path:
;;;; (setq load-path (cons "/the/full/path/to-your/dir" load-path))
;;;;
;;;; To turn the font-lock on by default, put in .emacs
;;;; (global-font-lock-mode t) ;; if you use gnu-emacs, or
;;;; (setq-default font-lock-auto-fontify t) ;; if you use xemacs.
;;;;
;;;; In GNU emacs faces `font-lock-preprocessor-face' and 
;;;; `font-lock-variable-name-face' may not be predefined.
;;;; In this case they are defined automatically when symp-mode.el
;;;; is loaded the first time. You can also define them yourself in .emacs:
;;;;
;;;; ;;; Make faces that are not in gnu-emacs font-lock by default
;;;; (defvar font-lock-preprocessor-face 'font-lock-preprocessor-face)
;;;; (defvar font-lock-variable-name-face 'font-lock-variable-name-face)
;;;; (make-face 'font-lock-preprocessor-face)
;;;; (make-face 'font-lock-variable-name-face)

(require 'font-lock)
(require 'symp-common)
(require 'symp-server)

;;;; Syntax definitions

(defvar symp-mode-syntax-table nil  "Syntax table used while in SYMP mode.")

(if symp-mode-syntax-table ()
    (let ((st (syntax-table)))
      (unwind-protect
	   (progn
	     (setq symp-mode-syntax-table (make-syntax-table))
	     (set-syntax-table symp-mode-syntax-table)
;	     (modify-syntax-entry ?_ "_")
;	     (modify-syntax-entry ?- "_")
	     (modify-syntax-entry ?_ "w")
;	     (modify-syntax-entry ?+ "w") ;; `+' is not a part of a word
;	     (modify-syntax-entry ?- "w") ;; neither is `-'
	     (modify-syntax-entry ?- ". 12") ;; Doesn't work???
	     (modify-syntax-entry ?\? "w")
	     (modify-syntax-entry ?: "." )
;	     (modify-syntax-entry ?# "<")
	     (modify-syntax-entry ?\f ">")
	     (modify-syntax-entry ?\n ">"))
	(set-syntax-table st))))

;;;; Fontification stuff

;;; Add symp-mode to the list of fontified modes
(if (string-match "XEmacs" emacs-version) ()
  (setq font-lock-defaults-alist 
	(cons '(symp-mode symp-font-lock-keywords
			 nil nil nil nil)
	      font-lock-defaults-alist)))

(defvar symp-mode-hook nil
  "Functions to run when loading an SYMP file.")

(defconst symp-keywords

'("module" "begin" "end" "let" "in" "var" "val" "op" "as" "fun" "fn" "theorem"
"lemma" "proposition" "spec" "specification" "corollary" "conjecture"
"implements" "refines" "simulates" "array" "fairness" "case" "endcase"
"and" "or" "implies" "iff" "not" "forall" "exists" "AG" "EG" "AF" "EF"
"AX" "EX" "Until" "Releases" "Always" "Sometimes" "Globally"
"Eventually" "of" "mod" "bool" "int" "nat" "next" "init" "include"
"type" "datatype" "symmetric" "finite" "statevar" "export" "all"
"open" "undefined" "anyvalue" "if" "then" "elsif" "else" "endif" "min"
"max" "mod" "div" "choose" "label" "pick" "endchoose" "foreach" "endforeach"
"nop" "false" "true" "self" "with" "sync" "async")

  "The list of SYMP keywords.")

(defconst symp-declaration-keywords
  '("module" "begin" "theorem" "lemma"
    "proposition" "spec" "specification" "corollary" "conjecture" "type"
    "datatype" "symmetric" "statevar" "export" )
  "The list of keywords that open a declaration. Used for indentation.")

(defconst symp-declaration-keywords-regexp
  (mapconcat 'symp-keyword-match symp-declaration-keywords "\\|"))

(defconst symp-openning-keywords
  '("case" "let" "choose")
;  '("var" "val" "fun" "case" "let" "choose" "next" "init")
  "The list of keywords that open a subexpression. Used for indentation.")

(defconst symp-openning-keywords-regexp
  (mapconcat 'symp-keyword-match symp-openning-keywords "\\|"))

(defconst symp-closing-keywords
  nil
;  '("end" "endcase" "endif" "endchoose")
  "The list of keywords that close a subexpression. Used for indentation.")

(defconst symp-closing-keywords-regexp
  (mapconcat 'symp-keyword-match symp-closing-keywords "\\|"))

(defconst symp-assignment-regexp
  (concat "\\(\\(\\(" (symp-keyword-match "init") "\\|"
		  (symp-keyword-match "next") 
		  "\\)(\\s-*\\([][_?.A-Za-z0-9-]+\\)\\s-*)\\)"
		  "\\|\\(\\s-*[][_?.A-Za-z0-9-]+\\)\\)\\s-*:=")
  "Regexp matching the beginning of an assignment. Used for indentation
purposes.")

(defconst symp-infix-operators
  '("<->" "<-" "->" ":=" "<=" ">=" "!=" "=" "\\[" "\\]"
    "-" "+" "|" "&" "<" ">" "|=")
  "The list of regexps that match SYMP infix operators. The distinction
is made primarily for indentation purposes.")

(defconst symp-infix-operators-regexp
  (mapconcat 'identity symp-infix-operators "\\|"))

(defconst symp-other-operators
  '("!")
  "Non-infix SYMP operators that are not listed in `symp-infix-operators'.")

(defconst symp-other-operators-regexp
  (mapconcat 'identity symp-other-operators "\\|"))

(defconst symp-operators (append symp-infix-operators symp-other-operators)
  "The list of regexps that match SYMP operators. It is set to the
concatenation of `symp-infix-operators' and `symp-other-operators'.")

(defconst symp-separator-regexp "[,.;():]"
  "A regexp that matches any separator in SYMP mode.")

(defconst symp-font-lock-keywords-1
  (purecopy
   (list
    (list (concat (symp-keyword-match "module") " *\\([-_?A-Za-z0-9]+\\)")
	  1 'font-lock-preprocessor-face)
    (list (concat "\\(" (symp-keyword-match "init") "\\|"
		  (symp-keyword-match "next")
		  "\\)(\\s-*\\([][_?.A-Za-z0-9-]+\\)\\s-*)\\s-*:=")
	  2 'font-lock-variable-name-face)
    ;;; "normal" assignments
    (list "\\([][_?.A-Za-z0-9-]+\\)\\s-*:="
	  1 'font-lock-variable-name-face)
    (list "\\<\\([Aa]\\|[Ee]\\)\\[" 1 'font-lock-keyword-face)
    (list (concat "\\("
		  (mapconcat 'identity symp-operators "\\|")
		  "\\)")
	  1 'font-lock-function-name-face ;'prepend
	  )
    (mapconcat 'symp-keyword-match symp-keywords "\\|")
;; Fix the `--' comments
   ; (list "\\(--.*$\\)" 1 'font-lock-comment-face t) 
    ))
  "Additional expressions to highlight in SYMP mode.")

(defconst symp-font-lock-keywords-2
  (purecopy 
   (append symp-font-lock-keywords-1
	   (list
	    (list "\\([{}]\\)" 1 'font-lock-type-face)
	    (list (concat "\\(" symp-separator-regexp "\\)")
		  1 'symp-font-lock-separator-face 'prepend))))
  "Additional expressions to highlight in SYMP mode.")
  
(defconst symp-font-lock-keywords
  (if font-lock-maximum-decoration
      symp-font-lock-keywords-2
      symp-font-lock-keywords-1))

(defun symp-minimal-decoration ()
  (interactive)
  (setq font-lock-keywords symp-font-lock-keywords-1))

(defun symp-maximal-decoration ()
  (interactive)
  (setq font-lock-keywords symp-font-lock-keywords-2))

;;;; Indentation

(defun symp-previous-line ()
  "Moves the point to the fisrt non-comment non-blank string before
the current one and positions the cursor on the first non-blank character."
  (interactive)
  (forward-line -1)
  (beginning-of-line)
  (skip-chars-forward " \t")
  (while (and (not (bobp)) (looking-at "$\\|--\\|#"))
    (forward-line -1)
    (beginning-of-line)
    (skip-chars-forward " \t")))

(defun symp-previous-indentation () 
  "Returns a pair (INDENT . TYPE). INDENT is the indentation of the
previous string, if there is one, and TYPE is 'openning, 'declaration
or 'plain, depending on whether previous string starts with an
openning, declarative keyword or neither. \"Previous string\" means
the last string before the current that is not an empty string or a
comment."
  (if (bobp) '(0 . 'plain)
    (save-excursion
      (symp-previous-line)
      (let ((type (cond ((or (looking-at symp-openning-keywords-regexp)
			     (looking-at symp-assignment-regexp)) 'openning)
			((looking-at symp-declaration-keywords-regexp)
			 'declaration)
			(t 'plain)))
	    (indent (current-indentation)))
	(cons indent type)))))

(defun symp-compute-indentation ()
  "Computes the indentation for the current string based on the
previous string. Current algorithm is too simple and needs
improvement."
  (save-excursion
   (beginning-of-line)
   (skip-chars-forward " \t")
   (cond ((looking-at symp-declaration-keywords-regexp) 0)
	 ((looking-at symp-assignment-regexp) 2)
	 (t (let* ((indent-data (symp-previous-indentation))
		   (indent (car indent-data))
		   (type (cdr indent-data)))
	      (setq indent
		    (cond ((looking-at symp-closing-keywords-regexp) 
			   (if (< indent 2) 0 (- indent 2)))
			  ((or (eq type 'openning) (eq type 'declaration))
			   (+ indent 2))
			  (t indent)))
	      indent)))))

(defun symp-indent-line ()
  "Indent the current line relative to the previous meaningful line."
  (interactive)
  (let* ((initial (point))
	 (final (let ((case-fold-search nil))(symp-compute-indentation)))
	 (offset0 (save-excursion
		    (beginning-of-line)
		    (skip-chars-forward " \t")
		    (- initial (point))))
	 (offset (if (< offset0 0) 0 offset0)))
    (indent-line-to final)
    (goto-char (+ (point) offset))))

(defvar symp-symp-mode-map nil
  "A private copy of the general SyMP keymap containing
language-specific bindings")

(if symp-symp-mode-map ()
  (progn
    (setq symp-symp-mode-map (copy-keymap symp-mode-map))
    (define-key symp-symp-mode-map [tab]  'symp-indent-line)))


;;;; Interactions with the server

(defun symp-mode ()
  "Major mode for SYMP specification files. 

\\{symp-symp-mode-map}

It's awfully incomplete, and probably same buggy.

Please send bugs and suggestions to berez+@cs.cmu.edu."
  (interactive)
  (use-local-map symp-symp-mode-map)
;;; Disable asking for the compile command
  (make-local-variable 'compilation-read-command)
  (setq compilation-read-command nil)
;;; Make all the variables with SYMP options local to the current buffer
;  (make-local-variable 'symp-command)
;  (make-local-variable 'symp-cache-size)
;  (make-local-variable 'symp-mini-cache-size)
;  (make-local-variable 'symp-key-table-size)
;  (make-local-variable 'symp-forward-search)
;  (make-local-variable 'symp-report-option)
;  (make-local-variable 'symp-order-file)
;  (make-local-variable 'symp-verbose-level)
;  (make-local-variable 'symp-command-line-args)
;  (make-local-variable 'symp-options-changed)
;  (setq symp-options-changed nil)
;;; Change the regexp search to be case sensitive
;;  (setq case-fold-search nil)
;;; Set syntax table
  (set-syntax-table symp-mode-syntax-table)
  (make-local-variable 'comment-start)
;; fix up comment handling
  (setq comment-start "--")
  (make-local-variable 'comment-end)
  (setq comment-end "")
  (make-local-variable 'comment-start-skip)
  (setq comment-start-skip "--+ *")
  (setq require-final-newline t)
;;; Define the major mode
  (setq major-mode 'symp-mode)
  (setq mode-name "SyMP")

;;; SyMP server variables
  (make-local-variable 'symp-server-process)
  (make-local-variable 'symp-server-status)  

;;; Load command line options for SYMP process
;  (let ((opt-file-name 
;	 (let ((match (string-match "\\.symp$"
;				    (buffer-file-name))))
;	   (if match
;	       (concat (substring (buffer-file-name)
;				  0 match)
;		       ".opt")
;	     (concat (buffer-file-name) ".opt")))))
;    (if (file-exists-p opt-file-name)
;	(load opt-file-name)))
;;; Do fontification, if necessary
  (setq font-lock-keywords 
	(if font-lock-maximum-decoration
	    symp-font-lock-keywords-2
	  symp-font-lock-keywords-1))
  (if (and (not (string-match "XEmacs" emacs-version))
	   symp-font-lock-mode-on font-lock-global-modes window-system)
      (progn
	(font-lock-mode 1)
;;;	(if (string-match "XEmacs" emacs-version) () 
;;;	  (font-lock-fontify-buffer))
	))
  ;; Watch the status of the inferior SYMP process
  (setq mode-line-process 'symp-server-status)
  (run-hooks 'symp-mode-hook))

(provide 'symp-mode)
