signature TYPECHECK =
  sig
    structure Evaluate: EVALUATE
    structure TopClosureStruct: TOP_CLOSURE
    sharing TopClosureStruct.ParseTreeStruct = Evaluate.ParserDefault.ParseTreeStruct

    type options = Evaluate.ParserDefault.Interface.Options.options
    type ParseTree = TopClosureStruct.ParseTreeStruct.ParseTree

(* typecheckExpr options context (expr,init_type)
      => (newExpr, newType, UidInst)

   It returns a triple:

   (1) a possibly updated expression with all names resolved and instantiated,
   (2) its most general type, and
   (3) a function mapping Uid's to objects (Uid is used, e.g. in type
       constructors to refer to the base type).

   The init_type is an initial type that the expression must match.
   If the expression is already typed, the new type will be restricted
   to the subtype of both if possible.  If type mismatch or ambiguous
   type is found, raises TypeError.  The context is the current
   closure (function or module) that defines the environment.  It must
   reference the parent closure, unless it's the top environment. *)

    val typeCheckExpr: options -> ParseTree -> ParseTree * ParseTree
	      -> ParseTree * ParseTree * (ParseTree -> ParseTree option)

(* typeCheckDecl options context decl => (decl list, UidInst)
   typeCheckProgram options program => (newProgram, UidInst)


   These are obvious extensions of typecheckExpr.  typeCheckDecl
   typechecks any individual object declaration (function (constructs
   the closure for it and updates the declaration with it), constant,
   assignment (type consistency checked in LHS vs. RHS, recursively go
   through the compound assignment expressions)).  It also handles
   variable and type declarations.

   typeCheckProgram typechecks the entire program in the toplevel
   context.  So, it doesn't require the extra `context' parameter. *)

    val typeCheckDecl: options -> ParseTree -> ParseTree
	  -> ParseTree list * (ParseTree -> ParseTree option)

    val typeCheckProgram: options -> ParseTree
	  -> ParseTree * (ParseTree -> ParseTree option)

    (* Return a module closure (context) for the given module expression *)
    val typeCheckModuleExpr: options -> ParseTree -> ParseTree
	  -> ParseTree * (ParseTree -> ParseTree option)

    (* Typecheck a theorem expression in a closure.  A theorem is either defined
       or referred to by its name. *)
    val typeCheckTheorem: options -> ParseTree -> ParseTree
	  -> ParseTree * (ParseTree -> ParseTree option)

    (* Auxiliary functions *)
    (* findNameIn[Local]Context context name
       Search for the name in the given context.  The "Local" variant searches only
       the current level. *)
    val findNameInContext: ParseTree -> ParseTree -> ParseTree option
    val findNameInLocalContext: ParseTree -> ParseTree -> ParseTree option

    (* Statistics on some function calls, mostly for debugging *)
    val typeCheckStat2string: unit -> string
    val resetTypeCheckStat: unit -> unit
  end
