signature TRANS_SPECIAL =
  sig
    structure TransCommon: TRANS_COMMON

    type Abstraction = TransCommon.Abstract.Abstraction
    type ParseTree = TransCommon.ParseTree
    type options = TransCommon.options
    type AsstVarsTree = TransCommon.AsstVarsTree
    type Model = TransCommon.Model

    (* Customize an AsstVarsTree to a particular property under a
       particular abstraction *)
    val customizeAsstVars: options -> (ParseTree -> ParseTree option) ->
      TransCommon.PrimitiveVars -> TransCommon.Cone -> int-> ParseTree list -> 
      Abstraction -> AsstVarsTree -> AsstVarsTree

    (* Perform COI reduction on the model, along with other necessary
       required transformations before generating the transition
       relation *)
    val specializeModel: options -> Model -> ParseTree list -> Model
  end
