functor TransPrepFun(structure TransCommon: TRANS_COMMON): TRANS_PREP =
  struct
    structure TransCommon = TransCommon

    open TransCommon

    open Hash
    open Pos
    open Abstract
    open Evaluate
    open ParserDefault
    open ParseTreeStruct
    open Interface
    open Options

(*      val dummyAVT = NormalAsstTree({norm=[],next=[],init=[]}, []) *)

    (* l1 - l2 as sets *)
    fun setMinus eq (l1, l2) = List.filter(fn x=>not(List.exists(fn y=>eq(x,y)) l2)) l1

    val unionPt = union ptEq

    (* Split the type `t' of expression `e' assinged to `delta' in the
       assignment type given by `flag', update the hash of primitive
       vars, and return the list of all primitive vars UNwrapped.  If
       `doUpdateCone' is true, also update the cone. *)

    fun splitType options findObject pvars lim cone doUpdateCone (delta, t, e, flag) = 
	let val funName = "splitType"
	    val addPrim = addPrim pvars
	    val addToCone = addToCone options findObject pvars lim cone
	    val addToCones = addToCones options findObject pvars lim cone
	    fun evalExpr force = 
		  if force orelse doUpdateCone  then evaluateExpr options findObject
		  else (fn _=>Fake)

	    val _ = pushFunStackLazy(funName, fn ()=>((pt2stringDebug delta)^", "
						      ^(pt2string t)^", "^(pt2string e)
						      ^"\n\n Primitive vars:\n\n"
						      ^(primVars2str pvars)))
	    val splitType = splitType options findObject pvars lim cone doUpdateCone
	    fun loop x =
		let val funName = "splitType/loop"
		    val _ = pushFunStackLazy(funName, fn()=>pt2string x)
		    val res = loop' x
		    val _ = popFunStackLazy(funName, fn()=>("["^(ptlist2str ", " res)^"]"))
		in res
		end
	    and loop'(t as TupleType (_, tlist)) =
		let   (* List of (tau_n, #n(delta), #n(e)) for all n *)
		    val triple = List.map (fn n => (List.nth (tlist, n),
						    evalExpr true (ExtractTuple (n, delta)),
						    evalExpr false (ExtractTuple (n, e))))
		      (List.tabulate (List.length tlist, fn i => i))
		    val Ns = List.map (fn (tn, deltan, en) => 
				       splitType (deltan, tn, en, flag)) triple
		in
		    (addPrim (delta, List.map #2 triple);
		     unionPt Ns)
		end
	      | loop'(RecordType (_, rlist)) = 
		let fun makeParts(RecordField{name=n,Type=tp}) = 
			  (tp,
			   evalExpr true (ExtractRecord (n, delta)),
			   evalExpr false (ExtractRecord (n, e)))
			| makeParts x = raise SympBug
			  ("collectAsstVars/splitType/parts: not RecordField: "
			   ^(pt2string x))
		      (* List of (e_n, delta.f_n, e.f_n) *)
		    val parts = List.map makeParts rlist
		    val Ns = List.map (fn (tn, deltan, en) => 
				       splitType (deltan, tn, en, flag)) parts
		  in
		    (addPrim (delta, List.map #2 parts);
		     unionPt Ns)
		  end
	      | loop'(FunType (_, t1, t2)) =
		  let
		    val dvals = getTypeValues options lim t1
		  in
		    (case dvals of
		       SOME lv => 
			 let (* List of (delta d, e d) *)
			   val pair = List.map (fn d => (evalExpr true (Appl (dp, delta, d)),
							 evalExpr false (Appl (dp, e, d)))) lv
			   val Ns = List.map (fn (deltan, en) => 
					      splitType (deltan, t2, en, flag)) pair
			 in		   
			   (addPrim (delta, List.map #1 pair);
			    unionPt Ns)
			 end
		     | NONE => (addPrim (delta, []);
				if doUpdateCone then 
				    (updateConeDestructive options findObject lim pvars cone 
				     (vtWrap flag delta, e); ())
				else ();
				[delta]))
		  end
	      (* Exactly the same as FunType *)
	      | loop'(ArrayType (_, t1, t2)) =
		  let
		    val dvals = getTypeValues options lim t1
		  in
		    (case
		       dvals of
		       SOME lv => 
			 let (* List of (delta d, e d) *)
			   val pair = List.map (fn d => (evalExpr true (Appl (dp, delta, d)),
							 evalExpr false (Appl (dp, e, d)))) lv
			   val Ns = List.map (fn (deltan, en) => 
					      splitType (deltan, t2, en, flag)) pair
			 in	
			   (addPrim (delta, List.map #1 pair);
			    unionPt Ns)
			 end
		     | NONE => (addPrim (delta, []);
				if doUpdateCone then
				    (updateConeDestructive options findObject lim pvars cone
				     (vtWrap flag delta, e); ())
				else ();
				[delta]))
		  end
	      | loop'(TypeInst (_, args, TypeClosure {name = name, uname = uname,
						params = params, def = def, 
						recursive = recursive,
						parent = parent})) =
		  let
		    val nt = TypeClosure {name = name, uname = uname, 
					  params = [],
					  def = instantiateType (args, params) def,
					  recursive = recursive,
					  parent = parent}
		  in
		    splitType (delta, nt, e, flag)
		  end
	      | loop'(tp as EnumType (_, clist)) =
		  let
		    fun extractor (a as TypeConstr{Type=tp,...}) =
			  (case tp of
			       FunType _ => SOME(fn x=> ExtractAppl(a, x))
			     | _ => NONE)
		      (* This shouldn't happen anymore *)
(*  		      | extractor (f as Of(_,c,t1)) = *)
(*  			SOME(fn x=> *)
(*  			     ExtractAppl (TypeConstr{name=c, *)
(*  						     uname=c, *)
(*  						     Type=FunType(dp,t1,tp)}, *)
(*  					  x)) *)
		      (* This shouldn't happen anymore *)
		      | extractor a = raise SympBug
				 ("collectAsstVars/splitType: not a TypeConstr:\n  "
				  ^(pt2string a))
(*  			     if isName a then *)
(*  				 SOME(fn x=>TypeConstr{name=a, *)
(*  						       uname=a, *)
(*  						       Type=tp}) *)
(*  			     else raise SympBug *)
(*  				 ("collectAsstVars/splitType: not a name/type constructor:\n  " *)
(*  				  ^(pt2string a)) *)
		    (* Lits of (C_n, EC_n(delta), EC_n e) for C_n's with arguments,
		       and if `e' is not a conflicting constructor. *)
		    val triple : (ParseTree * ParseTree * ParseTree) list
		      = List.mapPartial (fn n => (Option.map(fn extr=>
							     (n, extr delta,
							      evalExpr false (extr e)))
						  (extractor n))
			  (* if the top type constructor is known for the expression,
			     we only need that constructor.  The rest will raise
			     EvalError and will be ignored. *)
					   handle EvalError _ => NONE)
			clist
		    val innerX = 
			(case getPrimitiveIndexVar pvars delta of
			     SOME x => x
			   | NONE =>
			      let val x = ExtractIndex delta
				  (* val x = StateVar {name = un, uname = un, 
						    Type = AbstractType clist,
						    id = un} *)
			      in 
				 addPrimitiveIndexVarDestructive pvars delta x;
				 x
			      end)
		    val X = vtWrap flag innerX
		    val Ns = [innerX] 
			     :: (List.map (fn (cn, deltan, en) => 
					   splitType (deltan,
						      getExprType findObject deltan,
						      en, 
						      flag)) triple)
		  in
		    (addPrim (delta, innerX :: List.map #2 triple);
		     if doUpdateCone then 
			 (addToCone (X, varsFrom options findObject pvars lim e); ())
		     else ();
		     unionPt Ns)
		  end
	      | loop'(t as (TypeClosure {def = newt, recursive = r,...})) =
		  if r then 
		    (addPrim(delta, []);
		     if doUpdateCone then 
			 (updateConeDestructive options findObject lim pvars cone
			  (vtWrap flag delta, e); ())
		     else ();
		     [delta])
		  else
		    splitType (delta, newt, e, flag)
	      | loop'(t as Uid _) =
		    (case findObject t of
			 SOME newtp => splitType(delta, newtp, e, flag)
		       | NONE => 
			   (addPrim(delta, []);
			    if doUpdateCone then 
				(updateConeDestructive options findObject lim pvars cone
				 (vtWrap flag delta, e); ())
			    else ();
			    [delta]))
	      | loop' (StaticFormalType{value=SOME t,...}) = loop t
	      | loop' _ = (addPrim(delta, []);
		      if doUpdateCone then 
			  (updateConeDestructive options findObject lim pvars cone
			   (vtWrap flag delta, e); ())
		      else ();
		      [delta])
	    (* end of loop *)
	    val res = loop t
	    val _ = popFunStackLazy(funName, fn ()=>(ptlist2strDebug ",\n  " res))
	in res
	end  (* end of splitType *)

    (* Take a list of assignments in the ParseTree representation and
       convert them into a "raw" AsstTree.  Primitive vars and cone
       are not built at this step, and all the primitive vars at every
       node are empty. *)

    fun extractAsstTree assts =
	let val funName = "extractAsstTree"
	    val _ = pushFunStackLazy(funName, fn()=>"["^(ptlist2strDebug ", " assts)^"]")
	    val emptyVars = {init = [], next = [], norm = []}
	    fun handleConds [] = []
	      | handleConds ((CondAsst (_, e, AL)) :: rest) =
	      let val subtree = collectlist AL
	      in
		 (e, subtree) :: (handleConds rest)
	      end
	      | handleConds (x::_) = raise SympBug 
	         ("collectAsstVars/handleConds: Not CondAsst: "
		  ^(pt2stringDebug x))
            (* FIXME: conditional should inherit the label somehow *)
	    and handleCases [] = [] 
	      | handleCases ((ChoiceAsstClosure{pattern=pat,
						uname=uname,
						names=names,
						body=AL,...}) :: rest) =
		let val subtree = collectlist AL
		    val newClosure = 
			ChoiceAsstClosure{pattern=pat,
					  uname=uname,
					  names=names,
					  (* Erase unneeded fields *)
					  body=[], parent=Fake}
		in
		    (pat, subtree) :: (handleCases rest)
		end
	      | handleCases ((ch as ChoiceAsst(p,c,AL))::rest) =
		(c, collectlist AL)::(handleCases rest)
	      | handleCases (x::_) = raise SympBug 
	        ("collectAsstVars/handleCases: Not ChoiceAsstClosure: "
		 ^(pt2stringDebug x))

	    (* Sequent N; L; I |- A (single assts) *)
	    and collect (a as (InitAsst (_, gamma, e))) = InitAsstTree(emptyVars, gamma, e)
	      | collect (a as (NormalAsst (_, gamma, e))) = NormalAsstTree(emptyVars, gamma, e)
	      | collect (a as (NextAsst (_, gamma, e))) = NextAsstTree(emptyVars, gamma, e)
	      | collect (a as (LetAsstClosure {locals = locals,
					       parent = parent,
					       body = body})) =
		let val subtree = collectlist body
		in
		    LetAsstTree (emptyVars, locals, subtree)
		end
	      | collect (a as (IfAsst (_, condassts, elseasst))) =
		let val pairs = handleConds condassts
		    val last = collectlist elseasst
		in
		    IfAsstTree (emptyVars, pairs, last)
		end
	      | collect (a as (CaseAsst (_, e, caseassts))) =
		let val pairs = handleCases (caseassts)
		in
		    CaseAsstTree (emptyVars, e, pairs)
		end
	      | collect (a as (ChooseAsstClosure{names=varsOpt,
						 choices=choiceassts, ...})) =
		let val pairs = handleCases (choiceassts)
		in
		    ChooseAsstTree (emptyVars, varsOpt, pairs)
		end
	      | collect (ForeachAsstClosure{names=names,assts=assts,...}) =
		  ForeachAsstTree(emptyVars, names, collectlist assts)
	      | collect (LabeledAsst(_, label, asst)) =
		  LabeledAsstTree(emptyVars, label, collect asst)
	      | collect (a as Nop _) = NopAsstTree emptyVars
	      | collect x = raise SympBug
		  ("collectAsstVars/collect: not an assignment:\n  "
		   ^(pt2string x))

	    (* Sequent N; L; I |- AL *)
	    and collectlist [] = NopAsstTree emptyVars
	      | collectlist lst = 
		let fun loop [] = []
		      | loop (a::lst) = (collect a)::(loop lst)
		    val treeList = loop lst
		in 
		    case treeList of
			[] => NopAsstTree emptyVars
		      | [t] => t
		      | _ =>  ListAsstTree (emptyVars, treeList)
		end
	    val res = collectlist assts
	    val _ = popFunStackLazy(funName, fn()=>avt2str res)
	in
	    res
	end (* end of extractAsstTree *)

    (* Options for rebuilding the asst tree *)

    type rebuildAsstOptions = { checkAssts: bool,
			        balanceInitNext: bool }

    val rebuildAsstOptionsDefault = { checkAssts = false,
				      balanceInitNext = false }

    fun rebuildAsstOptionsCheckAssts({balanceInitNext = b, ...}:rebuildAsstOptions)  =
	{ checkAssts = true,
	  balanceInitNext = b }: rebuildAsstOptions

    fun rebuildAsstOptionsBalance({checkAssts = b, ...}:rebuildAsstOptions) =
	{ checkAssts = b,
	  balanceInitNext = true }: rebuildAsstOptions

    (* Traverse the AsstTree, extract the ground vars from the
       assignments and add them to the tree.  If `checkAssts' is true,
       verify that the assignments are complete and not double or
       circular.  The resulting tree is then balanced.  On the way,
       construct the new cone and PrimitiveVars database.  Returns
       (asstTree, cone, pvars). *)

    fun rebuildAsstVars options findObject pvars lim (stateVarsOpt, asstTree, opt) =
	let val funName = "rebuildAsstVars"
	    val { checkAssts = checkAssts,
		  balanceInitNext = balanceInitNext }: rebuildAsstOptions = opt
	    fun args() = 
		(case stateVarsOpt of
		     NONE => "NONE"
		   | SOME lst => "["^(ptlist2str ", " lst)^"]")
		^", "^(avt2str asstTree)^", "
		^(if checkAssts then "check" else "don't check")
	    val _ = pushFunStackLazy(funName, args)
	    val cone = makeCone() (* Global cone, update destructively *)
	    val pvars = copyPrimitiveVars pvars
	    val origVars = getAsstVars asstTree
	    val addPrim = addPrim pvars
	    val addToCone = addToCone options findObject pvars lim cone
	    val addToCones = addToCones options findObject pvars lim cone
	    val splitType = splitType options findObject pvars lim cone 
	    val emptyVars = {init = [], next = [], norm = []}
	    (* A string with an error message, or NONE. *)
	    val error = ref(NONE)
	    (* Lists of problematic variables: *)
	    (* Multiply assigned vars *)
	    val multiplyAssignedNormal = ref(NONE)
	    val multiplyAssignedNext = ref(NONE)
	    val multiplyAssignedInit = ref(NONE)
	    (* Variables appearing in too many places *)
	    val normalAndNext = ref(NONE)
	    val normalAndInit = ref(NONE)
	    (* Variables appearing in too few places *)
	    val initButNotNext = ref(NONE)
	    val nextButNotInit = ref(NONE)
	    val unassigned = ref(NONE)
	    fun addError str =
		error := SOME(case !error of
				  NONE =>  str
				| SOME s => (s^"\n\n"^str))
	    fun addErrorVars varList vars =
		varList := SOME(case !varList of
				    NONE => vars
				  | SOME lst => unionPt [vars, lst])

	    (* Given the list of lists of vars, find all vars that
	       appear in more than one list *)
	    fun repeats [] = []
	      | repeats [_] = []
	      | repeats (l::lst) =
		let fun ff x = List.exists(fn l => List.exists(fn y=> vtEqName(x,y)) l) lst
		    val vars = List.filter ff l
		in vars@(repeats lst)
		end
	    (* Collect all the pending errors and return the master error string, or NONE *)
	    fun processErrors() =
		((case !multiplyAssignedNormal of
		      SOME vars => addError("Multiply assigned normal variables:\n\n  "
					    ^(strlist2str "\n  " (List.map pt2string vars)))
		    | NONE => ());
		 (case !multiplyAssignedNext of
		      SOME vars => addError("Multiply assigned next variables:\n\n  "
					    ^(strlist2str "\n  " (List.map pt2string vars)))
		    | NONE => ());
		 (case !multiplyAssignedInit of
		      SOME vars => addError("Multiply assigned init variables:\n\n  "
					    ^(strlist2str "\n  " (List.map pt2string vars)))
		    | NONE => ());
		 (case !normalAndNext of
		      SOME vars => addError
			  ("These variables appear in both normal and next assignments:\n\n  "
			   ^(strlist2str "\n  " (List.map pt2string vars)))
		    | NONE => ());
		 (case !normalAndInit of
		      SOME vars => addError
			  ("These variables appear in both normal and init assignments:\n\n  "
			   ^(strlist2str "\n  " (List.map pt2string vars)))
		    | NONE => ());
		 (case !initButNotNext of
		      SOME vars => addError
			  ("These variables appear in init, but not in next assignments:\n\n  "
			   ^(strlist2str "\n  " (List.map pt2string vars)))
		    | NONE => ());
		 (case !nextButNotInit of
		      SOME vars => addError
			  ("These variables appear in next, but not in init assignments:\n\n  "
			   ^(strlist2str "\n  " (List.map pt2string vars)))
		    | NONE => ());
		 (case !unassigned of
		      SOME vars => addError
			  ("These variables are unassigned:\n\n  "
			   ^(strlist2str "\n  " (List.map pt2string vars)))
		    | NONE => ());
		 !error)
		 
	    (* Sequent Delta |-_1 gamma *)
	    fun findStateVars (Appl(_,v, d)) =
	      let 
		val primV = findStateVars v
	      in
		if isConst (d) then 
		  List.map (fn x => Appl (dp, x, d)) primV
		else
		  let
		    val t = getExprType findObject d
		    val tvals = (getTypeValues options lim t)
		  in
		    case tvals of
		      SOME lv => List.concat
			(List.map (fn x => (List.map 
					    (fn y => 
					     Appl(dp, x, y)) lv))
			 primV)
		    | NONE => primV
		  end
	      end
	      | findStateVars (ExtractRecord (fname, v)) =
	      let
		val primV = findStateVars v
	      in
		List.map (fn x => ExtractRecord (fname, x)) primV
	      end
	      | findStateVars v = [v]
	    fun wrap (x, NormalFlag) = NormalVar x
	      | wrap (x, NextFlag) = NextVar x
	      | wrap (x, InitFlag) = InitVar x

	    fun findPrimitiveCommon doUpdateCone (gamma, e, flag) =
	      let
		val svs = findStateVars gamma
		val svst = ((*  addPrim (gamma, svs); *)
			    List.map (fn s => (s, getExprType findObject s)) svs)
(*		val _ = print ("\nfoo: " ^ (pt2string gamma) ^ "\n")
		val _ = List.map (fn (s1, s2) => print (" " ^  (pt2string s1) 
							^ " : " ^ 
							(pt2string s2) ^
							"\n"))
		  svst *)
		fun ff(s, t) = splitType doUpdateCone (s, t, e, flag)
		val Ns = List.map ff svst
	      in
		unionPt Ns
	      end
	    fun findPrimitive (gamma, e, flag) = 
		  List.map (vtWrap flag) (findPrimitiveCommon true (gamma, e, flag))

	    (* Recursive descent into the assignment tree *)
            fun collect t =
		let val funName = "rebuildAsstVars/collect"
		    val _ = pushFunStackLazy(funName, fn()=>avt2str t)
		    val res = collect' t
		    val _ = popFunStackLazy(funName, fn()=>avt2str res)
		in res
		end
	    and handleConds [] = []
	      | handleConds ((e, subtree) :: rest) =
	      let
		val subtree = collect subtree
		val CLNI = getAsstVars subtree
	      in
		(addToCones (CLNI, varsFrom options findObject pvars lim e);
		 (e, subtree) :: (handleConds rest))
	      end
	    and handleCases [] = [] 
	      | handleCases ((cl, subtree) :: rest) =
		let val subtree = collect subtree
		in
		    (cl, subtree) :: (handleCases rest)
		end
	    (* Sequent N; L; I |- A (single assts) *)
	    and collect' (InitAsstTree(_, gamma, e)) =
		let val ground = findPrimitive (gamma, e, InitFlag)
		    val asstvars = {init=ground, next=[], norm=[]}
		in
		    InitAsstTree (asstvars, gamma, e)
		end
	      | collect' (a as (NormalAsstTree (_, gamma, e))) =
		let val ground = findPrimitive (gamma, e, NormalFlag)
		    val asstvars = {init=[], next=[], norm=ground}
		in
		    NormalAsstTree (asstvars, gamma, e)
		end
	      | collect' (a as (NextAsstTree (_, gamma, e))) =
		let val ground = findPrimitive (gamma, e, NextFlag)
		    val asstvars = {init=[], next=ground, norm=[]}
		in
		    NextAsstTree (asstvars, gamma, e)
		end
	      | collect' (LetAsstTree(_, locals, subtree)) =
		let val subtree = collect subtree
		    val CLNI = getAsstVars subtree
		in
		    LetAsstTree (CLNI, locals, subtree)
		end
	      | collect' (IfAsstTree(_, pairs, last)) =
		let val pairs = handleConds pairs
		    val last = collect last
		    val U = unionAV ((getAsstVars last)
				     ::(List.map (fn(_,t) => getAsstVars t) pairs))
		in
		    IfAsstTree (U, pairs, last)
		end
	      | collect' (CaseAsstTree(_, e, pairs)) =
		let val pairs = handleCases pairs
		    val U = unionAV (List.map (fn(_,t) => getAsstVars t) pairs)
		    val _ = addToCones (U, varsFrom options findObject pvars lim e)
		in
		    CaseAsstTree (U, e, pairs)
		end
	      | collect' (ChooseAsstTree (_, paramsOpt, pairs)) =
		let val pairs = handleCases pairs
		    (* Construct a single expr out of all the conditions to compute the cone *)
		    val conds = TupleExpr(dp, List.map #1 pairs)
		    val U = unionAV (List.map (fn(_,t) => getAsstVars t) pairs)
		    val _ = addToCones (U, varsFrom options findObject pvars lim conds)
		in
		    ChooseAsstTree (U, paramsOpt, pairs)
		end
	      | collect' (ForeachAsstTree(_, params, subtree)) =
		let val subtree = collect subtree
		    val CLNI = getAsstVars subtree
		in
		    ForeachAsstTree (CLNI, params, subtree)
		end
	      | collect' (LabeledAsstTree(_, label, subtree)) =
		let val subtree = collect subtree
		    val CLNI = getAsstVars subtree
		in
		    LabeledAsstTree (CLNI, label, subtree)
		end
	      | collect' (NopAsstTree _) = NopAsstTree emptyVars
	      | collect' (ListAsstTree(_, lst)) = collectlist lst
	    (* Sequent N; L; I |- AL *)
	    and collectlist [] = NopAsstTree emptyVars
	      | collectlist lst = 
		let fun loop [] = []
		      | loop (a::lst) = (collect a)::(loop lst)
		    (* Collect the list of lists of variables for the list of asst trees *)
		    fun getVars ([], norms, nexts, inits) = (norms, nexts, inits)
		      | getVars (t::lst, norms, nexts, inits) =
			let val {norm=norm, next=next, init=init} = getAsstVars t
			in getVars (lst, norm::norms, next::nexts, init::inits)
			end
		    val treeList = loop lst
		    val (norms, nexts, inits) = getVars(treeList, [], [], [])
		    val norm = unionV norms
		    val next = unionV nexts
		    val init = unionV inits
		    val U = {norm = norm, next = next, init = init}
		    (* Circularity is checked at the leaves, check only multiplicity *)
		    fun check() =
			let val _ = (case repeats norms of
					 [] => ()
				       | vars => addErrorVars multiplyAssignedNormal 
					     (List.map vtName vars))
			    val _ = (case repeats nexts of
					 [] => ()
				       | vars => addErrorVars multiplyAssignedNext 
					     (List.map vtName vars))
			    val _ = (case repeats inits of
					 [] => ()
				       | vars => addErrorVars multiplyAssignedInit 
					     (List.map vtName vars))
			    val _ = (case repeats [norm, next] of
					 [] => ()
				       | vars => addErrorVars normalAndNext 
					     (List.map vtName vars))
			    val _ = (case repeats [norm, init] of
					 [] => ()
				       | vars => addErrorVars normalAndInit 
					     (List.map vtName vars))
			in ()
			end
		    val _ = if checkAssts then check() else ()
		in
		    case treeList of
			[] => NopAsstTree emptyVars
		      | [t] => t
		      | _ =>  ListAsstTree (U, treeList)
		end

	    (* Auxiliary function to collect the stateVar's set of
	       primitive variables.  The expression is given as `Fake'
	       to raise an exception if it's used in this case (that
	       is, it shouldn't be used). *)

	    fun processStateVar v = findPrimitiveCommon false (v, Fake, NormalFlag)
	    val newTree = collect asstTree
	    val {norm=normV, next=nextV, init=initV} = getAsstVars newTree
	    val norm = List.map vtName normV
	    val next = List.map vtName nextV
	    val init = List.map vtName initV
	    fun check() =
		let val _ = (case setMinus ptEq (next, init) of
				 [] => ()
			       | vars => addErrorVars nextButNotInit vars)
		    val _ = (case setMinus ptEq (init, next) of
				 [] => ()
			       | vars => addErrorVars initButNotNext vars)
		    val assignedVars = unionPt [norm, next, init]
		    val stateVars = (case stateVarsOpt of
					 SOME lst => lst
				       | NONE => assignedVars)
		    val primVars = List.foldr (op @) [] (List.map processStateVar stateVars)
		    val _ = (case setMinus ptEq (primVars, assignedVars) of
				 [] => ()
			       | vars => addErrorVars unassigned vars)
		in ()
		end
	    (* Balance next and init vars *)
	    fun balanceVars tree =
		let val {norm=normV, next=nextV, init=initV} = getAsstVars tree
		    val next = List.map vtName nextV
		    val init = List.map vtName initV
		    val initNext = union ptEq [next, init]
		    val vars = {norm=normV,
				next=List.map(vtWrap NextFlag) initNext,
				init=List.map(vtWrap InitFlag) initNext}
		in
		    setAsstVars vars tree
		end
				
	    val _ = if checkAssts then check() else ()
	    val newTree = if balanceInitNext then balanceVars newTree else newTree
	    val res as (tree, cone, pvars) =
		(case processErrors() of
		     NONE => (balanceAsstTree newTree, cone, pvars)
		   | SOME str => raise TransError str)
	    val _ = popFunStackLazy(funName, fn()=>"\nAssignment Tree:\n"
				    ^(avt2str tree)
				    ^"\n\nCone of Influence:\n"
				    ^(cone2str cone)
				    ^"\n\nPrimitive Variables:\n"
				    ^(primVars2strDebug pvars))
	in res
	end (* end of rebuildAsstVars *)


    (* For a list of assignments generate an AsstVarsTree.  On the
       way, check for circular and multiple assignments, and if found
       any, raise TransError.  Also, check that all the `stateVars'
       are assigned. *)

    fun collectAsstVars options findObject lim (stateVars, assts) = 
	let val _ = pushFunStackLazy("collectAsstVars",
				     fn()=>"["^(ptlist2strDebug "," stateVars)
				     ^"],\n                ["
				     ^(ptlist2str ",\n                 " assts)^"]")
	    val rawAsstTree = extractAsstTree assts
	    val pvars = makePrimitiveVars()
	    val opt = rebuildAsstOptionsCheckAssts rebuildAsstOptionsDefault
	    val res as (asstTree, cone, pvars) =
		  rebuildAsstVars options findObject pvars lim (SOME stateVars, rawAsstTree, opt)
	    val _ = popFunStackLazy("collectAsstVars",
				    fn()=>"\nAssignment Tree:\n"
				    ^(avt2str asstTree)
				    ^"\n\nCone of Influence:\n"
				    ^(cone2str cone)
				    ^"\n\nPrimitive Variables:\n"
				    ^(primVars2strDebug pvars))
	in 
	    res
	end

    (* Later we either extend the functions above, or include more
       functions, to compute an abstracted transition relation,
       relative to a provided `Abstraction'. *)

  end
