signature TRANS_PREP =
  sig
    structure TransCommon: TRANS_COMMON

    type ParseTree = TransCommon.ParseTree
    type options = TransCommon.options
    type AsstVarsTree = TransCommon.AsstVarsTree
    type PrimitiveVars = TransCommon.PrimitiveVars
    type Cone = TransCommon.Cone
    type rebuildAsstOptions

    (* collectAsstVars options findObject lim (stateVars, assts) *)
    val collectAsstVars: options -> (ParseTree -> ParseTree option) -> int -> 
      (ParseTree list * ParseTree list) -> (AsstVarsTree * Cone * PrimitiveVars)

    (* Traverse the AsstTree, extract the ground vars from the
       assignments and add them to the tree.  The resulting tree is
       then balanced.  On the way, construct the new cone and
       PrimitiveVars database.  Returns (asstTree, cone, pvars).

       This is a handy function to apply to an abstracted or
       COI-filtered assignment tree.

       rebuildAsstVars options findObject lim (stateVars, asstTree) *)

    val rebuildAsstVars: options -> (ParseTree -> ParseTree option)
          -> PrimitiveVars -> int -> (ParseTree list option * AsstVarsTree * rebuildAsstOptions)
          -> (AsstVarsTree * Cone * PrimitiveVars)

    val rebuildAsstOptionsDefault: rebuildAsstOptions
    val rebuildAsstOptionsCheckAssts: rebuildAsstOptions -> rebuildAsstOptions
    val rebuildAsstOptionsBalance: rebuildAsstOptions -> rebuildAsstOptions

  end
