signature TRANS_GEN =
  sig
    structure TransCommon: TRANS_COMMON

    type Abstraction = TransCommon.Abstract.Abstraction
    type ParseTree = TransCommon.ParseTree
    type options = TransCommon.options
    type AsstVarsTree = TransCommon.AsstVarsTree
    type PrimitiveVars = TransCommon.PrimitiveVars
    type Model = TransCommon.Model

    (* substAVT options findObject pvars lim (tree, old, new) 
       Substitute `new' for `old' in the `tree' and return the new tree. *)
    val substAVT: options -> (ParseTree -> ParseTree option) -> PrimitiveVars
           -> int -> (AsstVarsTree * ParseTree * ParseTree) -> AsstVarsTree

    (* generateTrans options abs TypeSizeLimit asstTree => (norm, next, init)
       Generate a formula representing the transition relation given
       by the AsstVarsTree. *)
    val generateTrans: options -> (ParseTree -> ParseTree option) -> Abstraction
	  -> PrimitiveVars -> int -> AsstVarsTree
	  -> ParseTree * ParseTree * ParseTree

    (* Generate the 3 transition relation formulas (norm, next, init) for a Model *)
    val generateModelTrans: options -> Model -> ParseTree * ParseTree * ParseTree

    (* boolExpr options abs lim expr
       Translate a boolean expression into a boolean formula suitable for 
       the use in external model checkers *)
    val boolExpr: options -> (ParseTree -> ParseTree option) -> ParseTree list
	  -> Abstraction -> PrimitiveVars -> int -> ParseTree -> ParseTree

    (* Translate a theorem declaration into a primitive boolean formula *)
    val generateTheorem: options -> (ParseTree -> ParseTree option) -> ParseTree list 
	  -> Abstraction -> PrimitiveVars -> int -> ParseTree -> ParseTree

  end
