signature TRANS_SMV =
  sig

    structure Abstract : ABSTRACT
    structure Hash : HASH

    type ParseTree = Abstract.ParserDefault.ParseTreeStruct.ParseTree
    type options = Abstract.ParserDefault.Interface.Options.options
    type Str = Str.Str
    type VarSMVMapping = (ParseTree, Str) Hash.Hash
    type TypeValueMapping = (ParseTree, Str list) Hash.Hash

    val SMVcode : options -> (ParseTree -> ParseTree option)
	  -> int -> ParseTree list -> ParseTree list
          -> ParseTree -> ParseTree -> ParseTree
	  -> (Str * VarSMVMapping * TypeValueMapping)

  end
