functor TransFun(structure Hash: HASH
		 structure Abstract: ABSTRACT
		 structure Evaluate: EVALUATE
		 sharing Evaluate.ParserDefault = Abstract.ParserDefault): TRANS =
  struct
    structure Hash = Hash
    structure ParserDefault = Abstract.ParserDefault
    structure Evaluate = Evaluate

    structure TransCommon =
	TransCommonFun(structure Hash = Hash
		       structure Abstract = Abstract
		       structure Evaluate = Evaluate): TRANS_COMMON

    structure TransPrep = TransPrepFun(structure TransCommon = TransCommon)
    structure TransSpecial = TransSpecialFun(structure TransPrep = TransPrep)
    structure TransGen = TransGenFun(structure TransPrep = TransPrep)

    open TransCommon
    open TransPrep
    open TransGen
    open TransSpecial
    open ParserDefault
    open Interface
    open ParseTreeStruct
    open Abstract

    fun getModuleAssts(ModuleClosure{closure=cl,...}) =
	let fun loop ((a as Nop _)::lst) acc = loop lst (a::acc)
	      | loop ((a as NormalAsst _)::lst) acc = loop lst (a::acc)
	      | loop ((a as NextAsst _)::lst) acc = loop lst (a::acc)
	      | loop ((a as InitAsst _)::lst) acc = loop lst (a::acc)
	      | loop ((a as IfAsst _)::lst) acc = loop lst (a::acc)
	      | loop ((a as LetAsst _)::lst) acc = loop lst (a::acc)
	      | loop ((a as CaseAsst _)::lst) acc = loop lst (a::acc)
	      | loop ((a as ChooseAsstClosure _)::lst) acc = loop lst (a::acc)
	      | loop ((a as ForeachAsstClosure _)::lst) acc = loop lst (a::acc)
	      | loop ((a as LabeledAsst _)::lst) acc = loop lst (a::acc)
	      | loop (_::lst) acc = loop lst acc
	      | loop [] acc = List.rev acc
	in loop cl []
	end
      | getModuleAssts x = raise SympBug
	 ("getModuleAssts: not a module:\n  "^(pt2string x))

    fun makeModel(model, findObject) =
	let (* Accumulate all the primitive vars here *)
	    val globalPvars = ref(makePrimitiveVars())
	    val stateVars = ref []
	    val options = getOptions()
	    val verb = verb options
	    val verbDebug = verbDebug options
	    val lazyVerbDebugStr = lazyVerbDebugStr options
	    fun loop (Sync2(_,m1,m2)) = TransSync2(loop m1, loop m2)
	      | loop (Async2(_,m1,m2)) = TransAsync2(loop m1, loop m2)
	      | loop (SyncClosure{names=names, body=body, parent=p}) =
	          TransSync{names=names, body=loop body, parent=p}
	      | loop (c as AsyncClosure{names=names, body=body, parent=p}) =
	          TransAsync{names=names, body=loop body, parent=p}
	      | loop (m as ModuleClosure{name=name,
					 uname=uname,
					 closure=closure, ...}) =
		  let val options as { limit = lim, ...} = getOptions()
		      val declaredStateVars =
			    List.filter(fn (StateVar _) => true | _ => false) closure
		      val (assts,cone,pvars) = 
		        collectAsstVars options findObject lim (declaredStateVars, getModuleAssts m)
		      val _ = verbDebug "common" ("\n\nAssingment tree for the module `"
						  ^(case name of
							NONE => "<unnamed>"
						      | SOME n => pt2string n)
						  ^"':\n\n")
		      val _ = lazyVerbDebugStr "common" (fn()=>(avt2Str assts))
		      val _ = verbDebug "common" ("\n\nCone of Influence:\n\n")
		      val _ = lazyVerbDebugStr "common" (fn()=>(cone2Str cone))
		      val _ = verbDebug "common" ("\n\nPrimitive variables:\n\n")
		      val _ = lazyVerbDebugStr "common" (fn()=>(primVars2Str pvars))
		      val _ = verbDebug "common" ("\n\n")
		      val {init=initvars, norm=normvars, next=nextvars} = getAsstVars assts
		      val vars = List.map vtName (normvars@initvars)
		  in 
		     (globalPvars := mergePrimitiveVars(pvars, !globalPvars);
		      stateVars := vars@(!stateVars);
		      TransAtomic(AtomicModel{name=name, uname=uname,
					      assts=assts,
					      cone=cone,
					      pvars=pvars,
					      absModules=[]}))
		  end
	      | loop x = raise SympBug
		  ("Sequent-default/makeModel: invalid model declaration:\n  "
		   ^(pt2string x))
	    val abs = makeAbstraction()
	    val _ = verb("Building the model...")
	    val trans = loop model
	    val _ = verb("Building the model...done")
	in 
	    { trans=trans,
	      findObject=findObject,
	      stateVars = !stateVars,
	      pvars = (!globalPvars),
	      abs=abs }: Model
	end

  end
