(* The built-in declarations that are always present at the top level *)
functor TopClosureFun(structure ParseTreeStruct: PARSE_TREE): TOP_CLOSURE =
  struct
    structure ParseTreeStruct = ParseTreeStruct
    open ParseTreeStruct
    (* Global structure *)
    open Pos

    (* Dummy position to use in creating new ParseTree nodes.
       Now defined in Pos structure. *)
    (* val dp = (~1,~1)  *)

    val b2tp = FunType(dp,TupleType(dp,[BoolType dp,BoolType dp]),BoolType dp)
    val b1tp = FunType(dp,BoolType dp,BoolType dp)
    val b0tp = BoolType dp
    val int2bool = FunType(dp,TupleType(dp,[IntType dp,IntType dp]),BoolType dp)
    val int2tp = FunType(dp,TupleType(dp,[IntType dp,IntType dp]),IntType dp)
    val int1tp = FunType(dp,IntType dp,IntType dp)
    val a2bool = FunType(dp,TupleType(dp,[Tvar(dp,"a"),Tvar(dp,"a")]),BoolType dp)

    val topclosure =
	TopClosure[
		   (* Boolean operations *)
		   Object{name = And dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=And dp,Type=b2tp}},
		   Object{name = Or dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Or dp, Type=b2tp}},
		   Object{name = Implies dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Implies dp, Type=b2tp}},
		   Object{name = Arrow dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Implies dp, Type=b2tp}},
		   Object{name = Darrow dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Implies dp, Type=b2tp}},
		   Object{name = Iff dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Iff dp, Type=b2tp}},
		   Object{name = Not dp,
			  uname=Id(dp,newName()),
			  Type = b1tp,
			  def = Builtin{name=Not dp, Type=b1tp}},

		   (* General equality *)
		   Object{name = Eq dp,
			  uname=Id(dp,newName()),
			  Type = a2bool,
			  def = Builtin{name=Eq dp, Type=a2bool}},
		   Object{name = NotEq dp,
			  uname=Id(dp,newName()),
			  Type = a2bool,
			  def = Builtin{name=NotEq dp, Type=a2bool}},

		   (* CTL operators *)
		   Object{name = Ag dp,
			  uname=Id(dp,newName()),
			  Type = b1tp,
			  def = Builtin{name=Ag dp, Type=b1tp}},
		   Object{name = Af dp,
			  uname=Id(dp,newName()),
			  Type = b1tp,
			  def = Builtin{name=Af dp, Type=b1tp}},
		   Object{name = Eg dp,
			  uname=Id(dp,newName()),
			  Type = b1tp,
			  def = Builtin{name=Eg dp, Type=b1tp}},
		   Object{name = Ef dp,
			  uname=Id(dp,newName()),
			  Type = b1tp,
			  def = Builtin{name=Ef dp, Type=b1tp}},
		   Object{name = Ax dp,
			  uname=Id(dp,newName()),
			  Type = b1tp,
			  def = Builtin{name=Ax dp, Type=b1tp}},
		   Object{name = Ex dp,
			  uname=Id(dp,newName()),
			  Type = b1tp,
			  def = Builtin{name=Ex dp, Type=b1tp}},

		   Object{name = Au dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Au dp, Type=b2tp}},
		   Object{name = Eu dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Eu dp, Type=b2tp}},
		   Object{name = Ar dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Ar dp, Type=b2tp}},
		   Object{name = Er dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Er dp, Type=b2tp}},
		   Object{name = Globally dp,
			  uname=Id(dp,newName()),
			  Type = b1tp,
			  def = Builtin{name=Globally dp, Type=b1tp}},
		   Object{name = Eventually dp,
			  uname=Id(dp,newName()),
			  Type = b1tp,
			  def = Builtin{name=Globally dp, Type=b1tp}},
		   Object{name = NextTime dp,
			  uname=Id(dp,newName()),
			  Type = b1tp,
			  def = Builtin{name=NextTime dp, Type=b1tp}},
		   Object{name = Until dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Until dp, Type=b2tp}},
		   Object{name = Releases dp,
			  uname=Id(dp,newName()),
			  Type = b2tp,
			  def = Builtin{name=Releases dp, Type=b2tp}},

		   (* Arithmetic predicates *)
		   Object{name = Lt dp,
			  uname=Id(dp,newName()),
			  Type = int2bool,
			  def = Builtin{name=Lt dp, Type=int2bool}},
		   Object{name = Gt dp,
			  uname=Id(dp,newName()),
			  Type = int2bool,
			  def = Builtin{name=Gt dp, Type=int2bool}},
		   Object{name = Le dp,
			  uname=Id(dp,newName()),
			  Type = int2bool,
			  def = Builtin{name=Le dp, Type=int2bool}},
		   Object{name = Ge dp,
			  uname=Id(dp,newName()),
			  Type = int2bool,
			  def = Builtin{name=Ge dp, Type=int2bool}},

		   (* Arithmetic operators *)
		   Object{name = Plus dp,
			  uname=Id(dp,newName()),
			  Type = int2tp,
			  def = Builtin{name=Plus dp, Type=int2tp}},
		   Object{name = Minus dp,
			  uname=Id(dp,newName()),
			  Type = int2tp,
			  def = Builtin{name=Minus dp, Type=int2tp}},
		   (* Unary minus: goes in two flavors, in case we can't
		    * resolve it syntactically, like in `(op -)(5)'.
		    * Also, it must go _after_ binary minus (or "before" it from
		      the programmer point of view) not to obscure it. *)
		   Object{name = Minus dp,
			  uname=Id(dp,newName()),
			  Type = int1tp,
			  def = Builtin{name=UMinus dp, Type=int1tp}},
		   Object{name = UMinus dp,
			  uname=Id(dp,newName()),
			  Type = int1tp,
			  def = Builtin{name=UMinus dp, Type=int1tp}},
		   Object{name = Times dp,
			  uname=Id(dp,newName()),
			  Type = int2tp,
			  def = Builtin{name=Times dp, Type=int2tp}},
		   Object{name = Div dp,
			  uname=Id(dp,newName()),
			  Type = int2tp,
			  def = Builtin{name=Div dp, Type=int2tp}},
		   Object{name = Mod dp,
			  uname=Id(dp,newName()),
			  Type = int2tp,
			  def = Builtin{name=Mod dp, Type=int2tp}},
		   Object{name = Undefined dp,
			  uname=Id(dp,newName()),
			  Type = Tvar(dp,"a"),
			  def = Builtin{name=Undefined dp,Type=Tvar(dp,"a")}},
		   Object{name = Anyvalue dp,
			  uname=Id(dp,newName()),
			  Type = Tvar(dp,"a"),
			  def = Builtin{name=Anyvalue dp,Type=Tvar(dp,"a")}},
		   Object{name = True dp,
			  uname=Id(dp,newName()),
			  Type = b0tp,
			  def = Builtin{name=True dp, Type=b0tp}},
		   Object{name = False dp,
			  uname=Id(dp,newName()),
			  Type = b0tp,
			  def = Builtin{name=False dp, Type=b0tp}}]

  end
