(* ML-Yacc Parser Generator (c) 1989 Andrew W. Appel, David R. Tarditi 
 *
 * $Log: symp-join.sml,v $
 * Revision 1.1  2000/04/27 17:31:36  berez
 * Did massive restructuring of the source tree: moved the default proof
 * system and input language implementation, and emacs interface modules,
 * to their own directories.  Updated the makefile and source.cm files
 * accordingly.
 *
 * Revision 1.2  2000/02/17 16:54:43  berez
 * The new emacs lisp parser compiles and integrates with the system, the
 * -emacs command line flag causes all messages from SyMP to be printed
 * out on stdout in emacs lisp format (including all error and bug
 * messages).  This involved adding a extra function parameter to all
 * lexers `error' that prints error messages in the right way.
 *
 * Revision 1.1  1999/04/26 00:48:30  berez
 * Encapsulated the ParseTree type into a functor, so several parsers can
 * now safely coexist.  Not sure this is a safe hack in SML, but it works
 * in SML/NJ110.  Blame the ml-yacc.
 *
# Revision 1.1.1.1  98/11/23  21:09:55  berez
# Imported sources
# 
# Revision 1.1.1.1  98/09/15  11:49:36  berez
# Imported sources
# 
 * Revision 1.1.1.1  1997/01/14 01:38:04  george
 *   Version 109.24
 *
 * Revision 1.1.1.1  1996/01/31  16:01:42  george
 * Version 109
 * 
 *)

(* functor Join creates a user parser by putting together a Lexer structure,
   an LrValues structure, and a polymorphic parser structure.  Note that
   the Lexer and LrValues structure must share the type pos (i.e. the type
   of line numbers), the type svalues for semantic values, and the type
   of tokens.
*)

functor SYMPJoin(structure Lex : ARG_LEXER
	     structure ParseTreeStruct: PARSE_TREE
	     structure ParserData: PARSER_DATA
		     where type result = ParseTreeStruct.ParseTree;
	     structure LrParser : LR_PARSER
	     sharing ParserData.LrTable = LrParser.LrTable
	     sharing ParserData.Token = LrParser.Token
	     sharing type Lex.UserDeclarations.svalue = ParserData.svalue
	     sharing type Lex.UserDeclarations.pos = ParserData.pos
	     sharing type Lex.UserDeclarations.token = ParserData.Token.token)
		 : ARG_PARSER =
struct
    structure Token = ParserData.Token
    structure Stream = LrParser.Stream
 
    exception ParseError = LrParser.ParseError

    type arg = ParserData.arg
    type pos = ParserData.pos
    type result = ParserData.result
    type svalue = ParserData.svalue
    type lexarg = Lex.UserDeclarations.arg
    fun makeLexer ff = (fn lexarg=>(LrParser.Stream.streamify (Lex.makeLexer ff lexarg)))
    val parse = fn (lookahead,lexer,error,arg) =>
	(fn (a,b) => (ParserData.Actions.extract a,b))
     (LrParser.parse {table = ParserData.table,
	        lexer=lexer,
		lookahead=lookahead,
		saction = ParserData.Actions.actions,
		arg=arg,
		void= ParserData.Actions.void,
	        ec = {is_keyword = ParserData.EC.is_keyword,
		      noShift = ParserData.EC.noShift,
		      preferred_change = ParserData.EC.preferred_change,
		      errtermvalue = ParserData.EC.errtermvalue,
		      error=error,
		      showTerminal = ParserData.EC.showTerminal,
		      terms = ParserData.EC.terms}}
      )
     val sameToken = Token.sameToken
end

