(* Defines the list of proof rules.  The actual definitions of proof
   rules have their own module for the code clarity. *)

signature PROOF_RULES_DEFAULT =
  sig
    structure Sequent: SEQUENT
    type options = Sequent.InputLanguage.Options.options
    type ProofSystemTactic
    type ProofSystemTacticState

    type InferenceRule = Sequent.InferenceRule
    type InferenceRuleArgument = Sequent.InferenceRuleArgument
    type InferenceRuleArgumentSpec = Sequent.InferenceRuleArgumentSpec
    type InferenceRuleResult = Sequent.InferenceRuleResult
    type Sequent = Sequent.Sequent
    type SequentHints = Sequent.SequentHints
    type ProgramContext = Sequent.ProgramContext

    val proofRules: unit -> Sequent.InferenceRule list
    val proverCommands: unit -> Sequent.ProofSystemCommand list
    val getTacticName: ProofSystemTactic -> string
    val getTacticHelp: ProofSystemTactic -> string
    (* Extracting argument "types" from a tactic *)
    val getTacticArgs: ProofSystemTactic -> InferenceRuleArgumentSpec list
    (* applyTactic printFun (tactic, args, context, stateOpt) (seq, hintsOpt) continuation

       Applies `tactic' to the sequent `seq'.  This can be an
       intermediate step within the tactic from an optional state
       `stateOpt'.  Actions may also depend on the optional sequent
       hints.  If any rule has been applied to the sequent, the
       `continuation' is called which will install the rule in the
       proof tree and will call `applyTactic' again with the new
       state given to it. *)

    val applyTactic: bool -> (string -> unit)
	        -> (ProofSystemTactic * (InferenceRuleArgument list) * ProgramContext
		    * (ProofSystemTacticState option))
                -> (Sequent * (SequentHints option))
	        (* Result *)
	        -> (string * (InferenceRuleArgument list)
		    * ((Sequent * (SequentHints option)) list)
		    * (ProofSystemTacticState option)) option
  end
