functor PatternMatchFun(structure ParserDefault: PARSER_DEFAULT): PATTERN_MATCH =

  struct

    structure ParserDefault = ParserDefault

    open ListOps
    open ParserDefault
    open Interface
    open Pos
    open ParseTreeStruct
    open Options


    exception PatternMatchError of string

    fun pmEq (x, y) =
      let
	val sx = stripObjects x
	val sy = stripObjects y
      in
	if (isValue sx) andalso (isValue sy) then
	  SOME (ptEq (x, y))
	else
	  NONE
      end

    fun worstOpt (SOME false, _) = SOME false
      | worstOpt (_, SOME false) = SOME false
      | worstOpt (NONE, _) = NONE
      | worstOpt (_, NONE) = NONE
      | worstOpt (x, y) = x

    fun bestOpt (SOME true, _) = SOME true
      | bestOpt (_, SOME true) = SOME true
      | bestOpt (NONE, _) = NONE
      | bestOpt (_, NONE) = NONE
      | bestOpt (a, b) = a

    fun allOpt f [] = (SOME true) 
      | allOpt f (h::t) = 
      case (f h) of
	SOME true => allOpt f t
      | SOME false => (SOME false)
      | NONE => NONE

    fun existsOpt f [] = (SOME false)
      | existsOpt f (h::t) =
      case (f h) of
	SOME true => (SOME true)
      | SOME false => (existsOpt f t)
      | NONE => bestOpt (NONE, existsOpt f t)

    fun boolOptWorst (false, _) = SOME false
      | boolOptWorst (_, SOME false) = SOME false
      | boolOptWorst (_, NONE) = NONE
      | boolOptWorst _ = SOME true

    fun isTypeConstr(TypeConstr _) = true
      | isTypeConstr(Object{def=x,...}) = isTypeConstr x
      | isTypeConstr(ObjectInst{obj=x,...}) = isTypeConstr x
      | isTypeConstr _ = false

    fun matches options pat expr =
	let val _ = lazyVerbDebug options "matches"
	             (fn()=>"\nmatches("
		      ^(pt2stringDebug pat)^","^(pt2stringDebug expr)
		      ^")[\n")
	    fun matchRecord rlist (RecordAsst (_, name1, exp1)) =
		existsOpt (fn RecordAsst (_, name2, exp2) =>
			        boolOptWorst (ptEq (name1, name2),
					      matches options exp1 exp2)
	                    | Ellipsis _ => SOME true
			    | x => raise PatternMatchError 
				("Badly formed record: " ^ pt2stringDebug x))
		rlist
	      | matchRecord _ x = raise PatternMatchError 
		("Badly formed record: " ^ pt2stringDebug x)
	    val res =
	      (case (pat,expr) of
		   (Underscore(_), _) => (SOME true)
		 | (Id(_), _) => (SOME true)
		 | (PatternFormal _, _) => SOME true
		 | (ObjectInst{obj=obj,...}, x) => matches options obj x
		 | (p, Object {def = x, ...}) => matches options p x
		 | (p, ObjectInst {obj = x, ...}) => matches options p x
		 | (TuplePattern (_, tlist1), TupleExpr(_, tlist2)) =>
		     allOpt (fn (x, y) => matches options x y) (zip (tlist1, tlist2))
		 | (ApplPattern (_, p1, p2), Appl (_, e1, e2)) =>
		     worstOpt (matches options p1 e1, matches options p2 e2)
		 (* type constructors with args don't match those without *)
		 | (ApplPattern _, TypeConstr _) => SOME false
		 | (TypeConstr _, Appl(_,e1,_)) => 
		     if isTypeConstr e1 then SOME false
		     else NONE
		 | (RecordPattern (_, rlist1), RecordExpr(_, rlist2)) =>
		     allOpt (matchRecord rlist2) rlist1
		 | (TypeConstr{uname=n1,...}, TypeConstr{uname=n2,...}) =>
		     SOME(ptEq(n1,n2))
		 | (AsPattern(_,_,pat), e) => matches options pat e
		 | (x, y) => pmEq (x, y))
	    val _ = lazyVerbDebug options "matches"
		       (fn()=>"\nmatches = "
			^(case res of
			      SOME true => "SOME(true)"
			    | SOME false => "SOME(false)"
			    | NONE => "NONE")^"]\n")
	in res
	end
	
  end
